package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

/**
 * 参数传递dto：流程实例;
 *
 * @author : jerry7
 * @date : 2022-8-11
 */
@ApiModel(value = "ProcessInstanceDto", description = "流程实例")
@Getter
@Setter
public class ProcessInstanceDto extends TenantDto implements Serializable {

  private static final long serialVersionUID = 2379282632194682337L;
  
  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;
  /**
   * 流程key
   */
  @ApiModelProperty(name = "processKey", notes = "流程key", value = "流程key")
  private String processKey;
  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;
  /**
   * 业务表单编码
   */
  @ApiModelProperty(name = "businessFormNo", notes = "业务表单编码", value = "业务表单编码")
  private String businessFormNo;
  /**
   * 应用名称
   */
  @ApiModelProperty(name = "applicationName", notes = "应用名称", value = "应用名称")
  private String applicationName;
  /**
   * 业务编号
   */
  @ApiModelProperty(name = "businessCode", notes = "业务编号", value = "业务编号")
  private String businessCode;
  /**
   * 流程状态
   */
  @ApiModelProperty(name = "processStatus", notes = "流程状态", value = "流程状态")
  private String processStatus;
  /**
   * 流程实例状态(启用,禁用,暂停,结束)
   */
  @ApiModelProperty(name = "processInstanceStatus", notes = "流程实例状态(启用,禁用,暂停,结束)", value = "流程实例状态(启用,禁用,暂停,结束)")
  private String processInstanceStatus;
  /**
   * 流程名称
   */
  @ApiModelProperty(name = "processName", notes = "流程名称", value = "流程名称")
  private String processName;
  /**
   * 流程标题
   */
  @ApiModelProperty(name = "processTitle", notes = "流程标题", value = "流程标题")
  private String processTitle;
  /**
   * 总耗时
   */
  @ApiModelProperty(name = "processElapsedTime", notes = "总耗时", value = "总耗时")
  private String processElapsedTime;
  /**
   * 里程实例id
   */
  @ApiModelProperty(name = "processInstanceId", notes = "流程实例id", value = "流程实例id")
  private String processInstanceId;
  /**
   * 流程no
   */
  @ApiModelProperty(name = "processNo", notes = "流程no", value = "流程no")
  private String processNo;

  /**
   * 业务表单json数据
   */
  @ApiModelProperty("业务表单json数据")
  private String formData;

  /**
   * 扩展参数json
   */
  @ApiModelProperty("扩展参数json")
  private String extData;

  /** 流程备注 */
  @ApiModelProperty(value = "流程备注",required = false)
  private String remark;

  /**
   * 附件信息
   */
  @ApiModelProperty(value = "附件信息", required = false)
  private Collection<ProcessInstanceFilesDto> filesCodes;
  /**
   * 自选审批人信息
   */
  @ApiModelProperty(value = "自选审批人信息", required = false)
  private Map<String, Collection<ProcessUserDto>> taskAssignees;
  /**
   * 结束节点添加抄送人
   */
  @ApiModelProperty(value = "结束节点添加抄送人", required = false)
  private Map<String,Collection<ProcessUserDto>> copyConfigs;

  /**
   * 是否为流程检测，默认为false
   */
  @ApiModelProperty("是否为流程检测")
  private boolean isProcessValidate ;

}