package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程关联业务dto
 * @author: rentao
 * @date: 2022/8/8 11:42
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateBusinessDto", description = "流程关联业务dto")
public class ProcessTemplateBusinessDto extends UuidDto {

  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;

  /**
   * 业务菜单编码  数据来源于表单引擎
   */
  @ApiModelProperty("流程主题")
  private String processTheme;

  /**
   * 流程主题json  数据来源于表单引擎
   */
  @ApiModelProperty("流程主题json")
  private String processThemeJson;

  /**
   * 业务菜单编码  数据来源于表单引擎
   */
  @ApiModelProperty("业务菜单编码")
  private String businessCode;

  /**
   * 业务表单编码 数据来源于前端
   */
  @ApiModelProperty("业务表单编码")
  private String formCode;

  /**
   * 业务表单名称 数据来源于表单引擎
   */
  @ApiModelProperty("业务表单名称")
  private String formName;

  /**
   * 生效范围  com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum
   */
  @ApiModelProperty("生效范围")
  private String effectiveScope;

}
