package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

/**
 * 参数传递dto：流程节点代理人;
 * @author : Keller
 * @date : 2022-7-29
 */
@ApiModel(value = "ProcessTemplateNodeAssignee",description = "流程节点代理人")
@Getter
@Setter
public class ProcessTemplateNodeAssigneeDto implements Serializable{
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /** 修改人名称 */
  @ApiModelProperty(name = "modifyName",notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /** 修改人账号 */
  @ApiModelProperty(name = "modifyAccount",notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /** 修改时间 */
  @ApiModelProperty(name = "modifyTime",notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value = "创建人名称")
  private String createName;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /** 流程模板编号 */
  @ApiModelProperty(name = "templateId",notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /** 流程节点编号 */
  @ApiModelProperty(name = "nodeId",notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;
  /** 策略编号 */
  @ApiModelProperty(name = "strategyCode",notes = "策略编号名称", value = "策略编号名称")
  private String strategyCode;
  /** 策略名称 */
  @ApiModelProperty(name = "strategyName",notes = "策略名称", value = "策略名称")
  private String strategyName;
  /** 排序 */
  @ApiModelProperty(name = "sort",notes = "排序", value = "排序")
  private Integer sort;
  /** 用户审批人数据 */
  @ApiModelProperty(name = "processTemplateNodeAssigneeVars",notes = "用户审批人数据", value = "用户审批人数据")
  private Collection<ProcessTemplateNodeAssigneeVarDto> processTemplateNodeAssigneeVars;
}
