package com.biz.crm.workflow.sdk.dto;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 参数传递dto：流程节点;
 *
 * @author : Keller
 * @date : 2022-7-28
 */
@ApiModel(value = "ProcessTemplateNode", description = "流程节点")
@Getter
@Setter
public class ProcessTemplateNodeDto extends TenantFlagOpDto {
  /**
   * 流程任务编号
   */
  @ApiModelProperty(name = "processTaskId", notes = "流程任务编号", value = "流程任务编号")
  private String processTaskId;
  /**
   * 流程任务名称
   */
  @ApiModelProperty(name = "processTaskName", notes = "流程任务名称", value = "流程任务名称")
  private String processTaskName;
  /**
   * 流程任务说明
   */
  @ApiModelProperty(name = "processTaskDoc", notes = "流程任务说明", value = "流程任务说明")
  private String processTaskDoc;
  /**
   * 流程模板编号
   */
  @ApiModelProperty(name = "templateId", notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /**
   * 编号
   */
  @ApiModelProperty(name = "code", notes = "编号", value = "编号")
  private String code;
  /**
   * 名称
   */
  @ApiModelProperty(name = "name", notes = "名称", value = "名称")
  private String name;
  /**
   * 流程节点扩展属性信息(json格式)
   */
  @ApiModelProperty(name = "attributes", notes = "流程节点扩展属性信息(json格式) ", value = "流程节点扩展属性信息(json格式) ")
  private JSONObject attributes;

}
