package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/**
 * 参数传递dto：流程节点-用户任务节点;
 *
 * @author : Keller
 * @date : 2022-7-29
 */
@ApiModel(value = "ProcessTemplateNodeUserTask", description = "流程节点-用户任务节点")
@Getter
@Setter
public class ProcessTemplateNodeUserTaskDto implements Serializable, Cloneable {
  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;
  /**
   * 租户编号
   */
  @ApiModelProperty(name = "tenantCode", notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", notes = "创建人名称", value = "创建人名称")
  private String createName;
  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /**
   * 修改人名称
   */
  @ApiModelProperty(name = "modifyName", notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /**
   * 修改人账号
   */
  @ApiModelProperty(name = "modifyAccount", notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /**
   * 修改时间
   */
  @ApiModelProperty(name = "modifyTime", notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /**
   * 流程模板编号
   */
  @ApiModelProperty(name = "templateId", notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /**
   * 流程节点编号
   */
  @ApiModelProperty(name = "nodeId", notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;
  /**
   * 发起人重复跳过
   */
  @ApiModelProperty(name = "sponsorRepeatSkip", notes = "发起人重复跳过", value = "发起人重复跳过")
  private Boolean sponsorRepeatSkip;
  /**
   * 审批人重复跳过
   */
  @ApiModelProperty(name = "approverRepeatSkip", notes = "审批人重复跳过", value = "审批人重复跳过")
  private Boolean approverRepeatSkip;
  /**
   * 为空跳过
   */
  @ApiModelProperty(name = "nullSkip", notes = "为空跳过", value = "为空跳过")
  private Boolean nullSkip;
  /**
   * 是否可回退
   */
  @ApiModelProperty(name = "canBack", notes = "是否可回退", value = "是否可回退")
  private Boolean canBack;
  /**
   * 是否可编辑
   */
  @ApiModelProperty(name = "canEdit", notes = "是否可编辑", value = "是否可编辑")
  private Boolean canEdit;
  /**
   * 自选审批人
   */
  @ApiModelProperty(name = "signOptional", notes = "自选审批人", value = "自选审批人")
  private Boolean signOptional;
  /**
   * 审批签批类型
   */
  @ApiModelProperty(name = "signType", notes = "审批签批类型", value = "审批签批类型")
  private String signType;
  /**
   * 会签条件数量
   */
  @ApiModelProperty(name = "signCondition", notes = "会签条件数量", value = "会签条件数量")
  private String signCondition;
  /**
   * 按钮分组编号
   */
  @ApiModelProperty(name = "btnGroupCode", notes = "按钮分组编号", value = "按钮分组编号")
  private String btnGroupCode;
  /**
   * 按钮分组名称
   */
  @ApiModelProperty(name = "btnGroupName", notes = "按钮分组名称", value = "按钮分组名称")
  private String btnGroupName;
  /**
   * 用户节点审批人数据
   */
  @ApiModelProperty(name = "processTemplateNodeAssignees", notes = "用户节点审批人数据", value = "用户节点审批人数据")
  private Collection<ProcessTemplateNodeAssigneeDto> processTemplateNodeAssignees;
  /**
   * 用户节点按钮权限数据
   */
  @ApiModelProperty(name = "processTaskButtons", notes = "用户节点按钮数据", value = "用户节点按钮数据")
  private Collection<ProcessTaskButtonDto> processTaskButtons;
  /**
   * 用户节点抄送人配置数据
   */
  @ApiModelProperty(name = "processTaskCopyConfigs", notes = "用户节点抄送配置数据", value = "用户节点抄送配置数据")
  private Collection<ProcessTaskCopyConfigDto> processTaskCopyConfigs;
  /**
   * 用户节点关键指标数据
   */
  @ApiModelProperty(name = "processTaskIndicators", notes = "用户节点关键指标数据", value = "用户节点关键指标数据")
  private Collection<ProcessTaskIndicatorsDto> processTaskIndicators;
}