package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程适用范围明细dto
 * @author: rentao
 * @date: 2022/8/5 16:52
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateScopeDto", description = "流程适用范围明细dto")
public class ProcessTemplateScopeDto extends UuidDto {
  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;

  /**
   * 适用范围  com.biz.crm.workflow.sdk.strategy.ApplicationUserScopeStrategy 策略中编码
   */
  @ApiModelProperty("适用范围类型")
  private String processUserScopeType;

  /**
   * 范围业务编码
   */
  @ApiModelProperty("范围业务编码")
  private String scopeCode;

  /**
   * 范围业务名称
   */
  @ApiModelProperty("范围业务名称")
  private String scopeName;


}
