package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;
import java.util.Map;

/**
 * 工作流发起事件DTO
 *
 * @author jerry7
 * @date 2021/12/23 14:50
 */
@Getter
@Setter
@ApiModel("发起流程事件DTO")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Deprecated
public class StartProcessDto implements NebulaEventDto {

  /**
   * 流程key
   */
  @ApiModelProperty(value = "流程key")
  private String processKey;
  /**
   * 流程名称
   */
  @ApiModelProperty(value = "流程名称")
  private String processName;
  /**
   * 业务对象id
   */
  @ApiModelProperty(value = "业务对象id主键")
  private String businessId;
  /**
   * 业务对象编码
   */
  @ApiModelProperty(value = "业务对象编码")
  private String businessNo;
  /**
   * 流程标题
   */
  @ApiModelProperty(value = "流程标题")
  private String processTitle;
  /**
   * 流程详情
   */
  @ApiModelProperty(value = "流程详情")
  private String processDetail;
  /**
   * 流程变量
   */
  @ApiModelProperty(value = "流程变量")
  private Map<String, Object> variables;

  /**
   * 附件列表
   */
  @ApiModelProperty("附件列表")
  private List<String> attachmentList;

  /**
   * 关键指标 json 数组
   */
  @ApiModelProperty(value = "关键指标 json 数组")
  private String keyTargetListJson;

  private String targetTextWithHead;
  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;
  /**
   * 业务地址
   */
  @ApiModelProperty("业务地址")
  private String businessUrl;
  /**
   * 业务类型
   */
  @ApiModelProperty(value = "业务类型")
  private String bizType;
  /**
   * 流程发起人职位编码,空则默认当前登录人
   */
  @ApiModelProperty(value = "流程发起人职位编码,空则默认当前登录人")
  private String positionCode;
  /**
   * 发起人编码
   */
  @ApiModelProperty(value = "发起人编码")
  private String commitCode;
  /**
   * 发起时的备注
   */
  @ApiModelProperty(value = "发起时的备注")
  private String remark;
  /**
   * 菜单编码
   */
  @ApiModelProperty(value = "菜单编码")
  private String menuCode;
  /**
   * 业务流程类型
   */
  @ApiModelProperty(value = "业务流程类型")
  private String costType;
  /**
   * 业务来源系统
   */
  @ApiModelProperty(value = "业务来源系统")
  private String formType;
}
