package com.biz.crm.workflow.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:工作流 流程沟通状态
 * @author: rentao
 * @date: 2022/7/25 15:12
 */
@Getter
@AllArgsConstructor
public enum ProcessCommunicateStatusEnum {

  /**
   * 未处理
   */
  untreated("1", "1", "未处理", "1"),

  /**
   * 已处理
   */
  complete("2", "2", "已处理", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;


}
