package com.biz.crm.workflow.sdk.listener;


import com.biz.crm.workflow.sdk.dto.PositionInfoDto;
import com.biz.crm.workflow.sdk.vo.response.PositionInfoResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 用户信息事件类，接入工作流模块需提供此数据
 *
 * @author jerry7
 * @date 2021/12/23 15:12
 */
public interface PositionInfoListener extends NebulaEvent {

  /**
   * 根据角色编码集合查询角色编码关联的职位及其所有上级职位(包含角色关联职位自身)
   *
   * @param dto 角色编码集合
   * @return 职位及其所有上级职位
   */
  PositionInfoResponse onFindAllParentByRoleCodes(PositionInfoDto dto);

  /**
   * 根据职位id或者code查询职位列表
   *
   * @param dto 职位数据请求类
   * @return 职位列表
   */
  PositionInfoResponse onFindByIdsOrCodes(PositionInfoDto dto);

  /**
   * 分页获取职位列表(此接口提供于流程编辑)
   * @param dto 职位数据请求类
   * @return  职位分页列表
   */
  PositionInfoResponse onFindByConditions(PositionInfoDto dto);
}
