package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

/**
 * 描述：</br>流程完成的回调监听，该事件监听会通过businessCode进行区分，如果流程发起设置了businessCode，
 * 则只有配置了对应businessCode的监听才能获取到对应的通知
 *
 * @author keller
 * @date 2022/8/25
 */
public interface ProcessCompleteListener {

  /**
   * 获取流程业务编号(默认为空)
   */
  default String getBusinessCode() {
    return "";
  }

  /**
   * 当流程开始后触发该事件
   */
  void onProcessComplete(ProcessStatusDto dto);
}
