package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @description: 终端用户信息事件类，接入工作流模块需提供此数据
 * @author: rentao
 * @date: 2022/8/10 14:47
 */
public interface TerminalUserInfoListener extends NebulaEvent {

  /**
   * 按userCode查询
   * 根据用户的组织及下级查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByOrgLowerWithUserCode(UserInfoEventDto dto);
}
