package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 描述：</br>用户信息事件类，接入工作流模块需提供此数据
 * 为审批人选择提供用户信息
 *
 * @author keller
 * @date 2022/8/1
 */
public interface UserInfoListener extends NebulaEvent {

  /**
   * 按orgCodes查询
   *
   * @param dto 组织编码集合
   * @return 用户列表
   */
  UserInfoResponse findByOrgCodes(UserInfoEventDto dto);

  /**
   * 按userCodes查询
   *
   * @param dto 用户编码集合
   * @return 用户列表
   */
  UserInfoResponse findByUserCodes(UserInfoEventDto dto);

  /**
   * 按positionCodes查询
   *
   * @param dto 职位编码集合
   * @return 用户列表
   */
  UserInfoResponse findByPositionCodes(UserInfoEventDto dto);

  /**
   * 按roleCodes查询
   *
   * @param dto 角色编码集合
   * @return 用户列表
   */
  UserInfoResponse findByRoleCodes(UserInfoEventDto dto);

  /**
   * 按positionLevelCodes查询
   *
   * @param dto 职位级别编码集合
   * @return 用户列表
   */
  UserInfoResponse findByPositionLevelCodes(UserInfoEventDto dto);


  /**
   * 按userCode查询
   * 根据用户的组织查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByOrgWithUserCode(UserInfoEventDto dto);


  /**
   * 按userCode查询
   * 根据用户的组织及上级查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByOrgUpperWithUserCode(UserInfoEventDto dto);

  /**
   * 按userCode查询
   * 根据用户的组织及下级查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByOrgLowerWithUserCode(UserInfoEventDto dto);

  /**
   * 按userCode查询
   * 根据用户的职位上级查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByPositionUpperWithUserCode(UserInfoEventDto dto);

  /**
   * 按userCode查询
   * 根据用户的职位上级查询（不包含本级职位）
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByPositionUpperByUserCode(UserInfoEventDto dto);

  /**
   * 按userCode查询
   * 根据用户的职位下级查询
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  UserInfoResponse findByPositionLowerWithUserCode(UserInfoEventDto dto);
}
