package com.biz.crm.workflow.sdk.register;

import com.biz.crm.workflow.sdk.service.process.ProcessNodeGroup;
import com.biz.crm.workflow.sdk.strategy.button.ProcessButtonStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.extensionfield.ProcessExtensionFieldStrategy;
import com.biz.crm.workflow.sdk.strategy.indicator.ProcessIndicatorStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsToUserStrategy;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.biz.crm.workflow.sdk.strategy.scope.ApplicationUserScopeStrategy;

import java.util.Collection;

/**
 * 描述：</br>流程模板注册器，通过该注册器实现扩展自定义话流程设置
 * 通过中间人模式对流程中使用的数据进行注册，可配置的内容如下
 * 1、流程发起可见范围（集合）
 * 2、自定义的任务节点（集合）
 * 3、用户任务节点审批人(集合）
 * 4、流程审批可用按钮(集合）
 * 5、流程指标(集合)
 * 6、短信平台
 * 7、短信平台收件人(集合)
 *
 * @author keller
 * @date 2022/7/20
 */
public interface ProcessTemplateRegister {

  /**
   * 流程发起可见范围支持多个
   *
   * @return
   */
  Collection<Class<? extends ApplicationUserScopeStrategy>> getApplicationUserScopeStrategies();

  /**
   * 流程审批可用按钮
   *
   * @return
   */
  Collection<Class<? extends ProcessButtonStrategy>> getProcessButtonStrategies();

  /**
   * 流程节点分组信息
   *
   * @return
   */
  Collection<Class<? extends ProcessNodeGroup>> getProcessNodeGroups();

  /**
   * 用户任务节点审批人
   *
   * @return
   */
  Collection<Class<? extends TracingStrategy>> getTracingStrategies();

  /**
   * 流程指标策略
   *
   * @return
   */
  Collection<Class<? extends ProcessIndicatorStrategy>> getProcessIndicatorStrategies();

  /**
   * 流程扩展字段
   *
   * @return
   */
  Collection<Class<? extends ProcessExtensionFieldStrategy>> getProcessExtensionFieldStrategies();

  /**
   * 短信平台策略
   *
   * @return
   */
  Class<? extends SmsStrategy> getSmsStrategyStrategies();

  /**
   * 短信平台收件人策略
   *
   * @return
   */
  Collection<Class<? extends SmsToUserStrategy>> getSmsToUserStrategies();

  /**
   * 委托人寻人策略
   *
   * @return
   */
  Collection<Class<? extends ProcessDelegateTypeStrategy>> getProcessDelegateTypeStrategies();

  /**
   * 委托人寻人策略
   *
   * @return
   */
  Collection<Class<? extends ProcessDelegateMandataryTypeStrategy>> getProcessDelegateMandataryTypeStrategies() ;
}
