package com.biz.crm.workflow.sdk.service.process;

import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import org.flowable.engine.delegate.DelegateExecution;

/**
 * 流程节点基础接口
 * 1、提供接口的xml标签类型
 * 2、节点名称显示
 * 3、节点运行时上下文数据处理器
 * 4、节点属性的保存、删除、查询方法
 * 5、自动任务的执行业务逻辑
 */
public interface ProcessNode {

  /**
   * 获取xml标签
   *
   * @return
   */
  String getXmlElement();

  /**
   * 节点编号
   *
   * @return
   */
  String getCode();

  /**
   * 获取节点显示名称
   *
   * @return
   */
  String getLabel();

  /**
   * 节点变量名称
   */
  String getVarName();

  /**
   * 节点数据保存处理器
   *
   * @param nodeDto
   */
  void onSaveHandle(ProcessTemplateNodeDto nodeDto);

  /**
   * 根据节点编号删除节点数据
   *
   * @param nodeId
   */
  void onRemoveHandle(String nodeId);

  /**
   * 节点数据查询处理器
   *
   * @param nodeVo
   */
  void onRequestHandle(ProcessTemplateNodeVo nodeVo);

  /**
   * 自动节点自动执行逻辑
   * 针对自动节点执行逻辑的定义
   *
   * @param delegateExecution
   */
  default void autoExecute(DelegateExecution delegateExecution) {
  }

  /**
   * 可用端
   * @return
   */
  String getProcessNodeType();
}
