package com.biz.crm.workflow.sdk.strategy.button;

import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;

/**
 * @description: 流程按钮注册器
 * @author: rentao
 * @date: 2022/7/29 9:45
 */
public interface ProcessButtonStrategy {

  /**
   * 这个方法将返回具体流程按钮控制策略的全系统唯一类型编号，注意：如果系统中类型编号重复，则系统启动时会报错
   * @return
   */
  String getProcessButtonCode();

  /**
   * 该方法将返回这个具体流流程按钮控制策略的中文说明信息
   * @return
   */
  String getProcessButtonDesc();

  /**
   * 该方法将返回排序
   * @return
   */
  Integer getIndex();

  /**
   * 处理流程任务
   * @return
   */
  void handleTask(TaskDto dto);

  /**
   * 可用端
   * @return
   */
  String getProcessButtonType();
}
