package com.biz.crm.workflow.sdk.strategy.delegatetype;

import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 委托人策略接口
 * @author : rentao
 * @date : 2022/11/23 15:37
 */
public interface ProcessDelegateTypeStrategy {

  /**
   * 这个方法将返回具体流程委托人策略的全系统唯一类型编号，注意：如果系统中类型编号重复，则系统启动时会报错
   * @return
   */
  String getProcessDelegateTypeCode();

  /**
   * 该方法将返回这个具体流流程委托人策略的中文说明信息
   * @return
   */
  String getProcessDelegateTypeDesc();

  /**
   * 该方法将返回排序
   * @return
   */
  Integer getIndex();

  /**
   * 删除方法
   * @return
   */
  void deleteByDelegateConfigId(List<String> configIds);

  /**
   * 新增方法
   * @return
   */
  List<ProcessDelegateConfigDetailVo> onCreate(ProcessDelegateConfigDto processDelegateConfigDto);

  /**
   * 修改方法
   * @return
   */
  List<ProcessDelegateConfigDetailVo> onUpdate(ProcessDelegateConfigDto processDelegateConfigDto);

  /**
   * 查询方法
   * @return
   */
  List<ProcessDelegateConfigDetailVo> findByDelegateConfigId(String delegateConfigId);

  /**
   * 寻人方法
   * codes 业务信息数据
   * @return type+username数据集合
   */
  Set<String> onHandle(Collection<String> codes);

}
