package com.biz.crm.workflow.sdk.strategy.tracing;

import com.biz.crm.workflow.sdk.vo.UserVo;
import org.springframework.core.Ordered;

import java.util.Collection;
import java.util.Set;

/**
 * 寻人策略接口，提供给流程引擎任务节点进行审批人寻找时候的接口
 */
public interface TracingStrategy extends Ordered {

  /**
   * 策略编号（唯一标识符，用来确认策略）
   * @return
   */
  String getCode();

  /**
   * 策略名称（用来提供前端页面显示的名称）
   * @return
   */
  String getName();


  /**
   * 寻人逻辑处理，返回寻人账号信息
   * 根据编号返回对应的处理人行号信息
   * @param codes
   */
  Set<String> onHandle(Collection<String> codes,String taskDefinitionKey, String taskId,String processInstanceId,String startUserName);

  /**
   * 寻人逻辑处理，返回寻人账号 名称 类型
   * 根据编号返回对应的处理人行号信息
   *
   * @param codes
   */
  default Set<UserVo> onHandleUserVos(Collection<String> codes, String taskId, String processInstanceId, String startUserName) {
    return null;
  }

}
