package com.biz.crm.workflow.sdk.vo;

import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 客户联系人Vo
 * @author: rentao
 * @date: 2022/8/10 14:55
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerContactVo", description = "客户联系人Vo")
public class CustomerContactVo extends EventResponse {

  /**
   * 联系人姓名
   */
  @ApiModelProperty("联系人姓名")
  private String contactName;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  private String contactPhone;
  /**
   * 主联系人,1是0否
   */
  @ApiModelProperty("主联系人(true:是,false:否)")
  private Boolean contactMain;
}
