package com.biz.crm.workflow.sdk.vo;


import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import java.util.List;

/**
 * 组织表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织表")
@AllArgsConstructor
@NoArgsConstructor
public class OrgVo extends EventResponse {
  private static final long serialVersionUID = 7385493313870750219L;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;
  /**
   * 组织类型
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;
  /**
   * 组织类型name
   */
  @ApiModelProperty("组织类型（orgType字段经过数据字典翻译后的值）")
  private String orgTypeName;
  /**
   * 组织描述
   */
  @ApiModelProperty("组织描述")
  private String orgDesc;
  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;
  /**
   * 上级组织名称
   */
  @ApiModelProperty("上级组织名称")
  private String parentName;
  /**
   * 父节点
   */
  @ApiModelProperty("父节点")
  private OrgVo parent;
  /**
   * 子节点
   */
  @ApiModelProperty("子节点")
  private List<OrgVo> children;
}
