package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 返回vo
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作流文件回显类")
public class ProcessFileVo extends TenantVo {


    @ApiModelProperty("流程实例ID")
    private String processInstId;

    @ApiModelProperty("任务ID（审批时上传文件）")
    private String taskId;

    @ApiModelProperty("节点ID（审批时上传文件）")
    private String nodeId;

    @ApiModelProperty("节点编码（审批时上传文件）")
    private String nodeCode;

    @ApiModelProperty("节点名称（审批时上传文件）")
    private String nodeName;

    @ApiModelProperty("文件名称")
    private String objectName;

    @ApiModelProperty("文件路径")
    private String fileAddress;

    @ApiModelProperty("文件类型（1-流程提交文件，2-审批提交文件）")
    private Integer fileType;


}