package com.biz.crm.workflow.sdk.vo;

import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 描述：</br>审批人用户信息
 *
 * @author keller
 * @date 2022/8/1
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户信息")
@AllArgsConstructor
@NoArgsConstructor
public class UserVo extends EventResponse {

  /**
   * 用户编号(审批流中识别用户身份)
   */
  private String userCode;

  /**
   * 用户信息（用户界面显示）
   */
  private String userName;

  /**
   * 电话号码
   */
  private String userPhone;

  /**
   * 身份类型
   */
  private String identityType;


  @ApiModelProperty("生效状态 003停用，009启用")
  private String enableStatus;

  @ApiModelProperty("是否删除 003停用，009启用")
  private String delFlag;

}
