package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * 描述：</br>工作流系统中特有的一种操作用户，只有租户、账户和身份信息
 *
 * @author keller
 * @date 2022/8/19
 */
@AllArgsConstructor
@NoArgsConstructor
@Getter
public class WorkflowUserIdentity extends AbstractCrmUserIdentity {

  /**
   * 账号
   */
  private String account;

  /**
   * 用户名称
   */
  private String userName;

  /**
   * 职位编号
   */
  private String postCode;

  /**
   * 职位名称
   */
  private String postName;

  /**
   * 组织编号
   */
  private String orgCode;

  /**
   * 组织名称
   */
  private String orgName;

  /**
   * 租户编号
   */
  private String tenantCode;

  /**
   * 角色编号数组
   */
  private String[] roleCodes;


  @Override
  public Integer getLoginType() {
    // 本系统无登录相关功能，需要依赖其他系统本身的登录信息
    return 1;
  }

  @Override
  public String getRealName() {
    if (StringUtils.isBlank(super.getRealName())) {
      return this.userName;
    } else {
      return super.getRealName();
    }
  }
}
