/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.api.controller;

import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.TtAuditActFeign;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"ttApiActController"})
@RestController
public class TtApiActController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtAuditActFeign ttAuditActFeign;

    @GetMapping(value={"selectByPrimaryKey"})
    public AjaxJson<TtActEntity> selectByPrimaryKey(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getTtActVoByActCode"})
    public AjaxJson<TtActEntity> getTtActVoByActCode(@RequestParam(value="actCode") String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = this.ttActService.getTtActVoByActCode(actCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"updateAuditStatus"})
    public AjaxJson updateAuditStatus(@RequestParam(value="detailCode") List<String> detailCode) {
        AjaxJson ajaxJson = new AjaxJson();
        this.ttActService.updateAuditStatus(detailCode);
        return ajaxJson;
    }

    @GetMapping(value={"getActEntitys"})
    public AjaxJson<TtActEntity> getActEntitys(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entitys = this.ttActService.getActEntitys(codes);
        ajaxJson.setObjList(entitys);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtActPage"})
    public DataGrid findTtActPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> info = null;
        vo.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        if (StringUtil.isNotEmpty((CharSequence)vo.getIsAuditStr())) {
            ArrayList<String> actTypes = new ArrayList<String>();
            String[] is_audit = vo.getIsAuditStr().split(",");
            if (is_audit != null && is_audit.length > 0) {
                for (int i = 0; i < is_audit.length; ++i) {
                    actTypes.add(is_audit[i]);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(actTypes)) {
                vo.setActTypes(actTypes);
            }
        }
        info = this.ttActService.findTtActPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"findTtActDetailPage"})
    public List<TtActDetailVo> findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = null;
        ArrayList<TtActDetailVo> ttActDetailVos = new ArrayList<TtActDetailVo>();
        List actEntities = ApiResultUtil.listResult((AjaxJson)this.ttAuditActFeign.getActCodeByTempId(vo.getTempUuid()), (boolean)true);
        List<String> actCodes = new ArrayList<String>();
        actCodes.add("_");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
            actCodes = actEntities.stream().map(TtAuditActEntity::getActCode).collect(Collectors.toList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(info = this.ttActDetailService.findTtActDetailByActsPage(vo, (Page)page, actCodes)).getList())) {
            info.getList().forEach(item -> {
                TtCostTypeFineEntity ttCostTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, item.getActSubclassCode()).getObj();
                if (StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.DDFY.getValue()) || StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.HFFY.getValue())) {
                    ttActDetailVos.add((TtActDetailVo)item);
                }
            });
        }
        return ttActDetailVos;
    }

    @RequestMapping(value={"findTtActAdvanceList"})
    public DataGrid findTtActAdvanceList(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> ttActVos = this.ttActService.findTtActListForAdvance(vo, (Page)page);
        return new DataGrid(ttActVos);
    }

    @GetMapping(value={"getActEntitysByDetailCode"})
    public AjaxJson<TtActEntity> getActEntitysByDetailCode(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entities = this.ttActService.getActEntitysByDetailCode(codes);
        ajaxJson.setList(entities);
        return ajaxJson;
    }
}

