/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.project.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.project.service.ActProjectActivitiTargetRefreshExtend;
import com.biz.eisp.act.project.service.ActProjectActivitiTargetTextExtend;
import com.biz.eisp.act.project.service.ActProjectService;
import com.biz.eisp.act.project.service.TtActProjectActivitiVariablesExtend;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.TaProcessFeign;
import com.biz.eisp.activiti.TaProcessOrgPageFeign;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.vo.ActTargetContentObjVo;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.project.vo.ActProjectSaveVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actProjectController"})
public class ActProjectController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private TaProcessFeign taProcessFeign;
    @Autowired
    private ActProjectService actProjectService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired
    private TmOrgFeign tmOrgFeign;
    @Autowired
    private TaProcessOrgPageFeign taProcessOrgPageFeign;
    @Autowired(required=false)
    private TtActProjectActivitiVariablesExtend ttActProjectActivitiVariablesExtend;
    @Autowired(required=false)
    private ActProjectActivitiTargetTextExtend actProjectActivitiTargetTextExtend;
    @Autowired(required=false)
    private ActProjectActivitiTargetRefreshExtend actProjectActivitiTargetRefreshExtend;

    @RequestMapping(value={"findActProjectListPage"})
    @ResponseBody
    public DataGrid findActProjectListPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.project.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findActBudgetListPage"})
    @ResponseBody
    public AjaxJson<TtActbudgetEntity> findActBudgetListPage(HttpServletRequest request, TtActVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page = new EuPage(request);
        PageInfo<TtActbudgetEntity> info = this.ttActbudgetService.findActBudgetListPage(vo, (Page)page);
        ajaxJson.setList(info.getList());
        return ajaxJson;
    }

    @RequestMapping(value={"getActProjectSaveVoByCode"})
    @ResponseBody
    public AjaxJson<ActProjectSaveVo> getActProjectSaveVoByCode(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        ActProjectSaveVo actProjectSaveVo = this.actProjectService.getActProjectSaveVoByCode(null, id);
        ajaxJson.setObj((Object)actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.actProjectService.saveOrUpdate(actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActTargetVo actTargetVo = new ActTargetVo();
        if (actProjectSaveVo.getTarget() == null || !StringUtil.isNotBlank((CharSequence)actProjectSaveVo.getTarget().getHeadTarget())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        String head = actProjectSaveVo.getTarget().getHeadTarget();
        List targetConfigEntities = JsonPropertyUtil.toArray((String)head, ActTargetConfigEntity.class);
        actTargetVo.setHead(targetConfigEntities);
        if (this.actProjectActivitiTargetRefreshExtend != null) {
            actTargetVo.setItems((List)this.actProjectActivitiTargetRefreshExtend.activitiTargetRefresh(actProjectSaveVo));
        } else if (actProjectSaveVo.getTarget() != null && StringUtil.isNotBlank((CharSequence)actProjectSaveVo.getTarget().getHeadTarget())) {
            head = actProjectSaveVo.getTarget().getHeadTarget();
            JSONArray jsonArray = new JSONArray();
            List targetConfigEntities2 = JsonPropertyUtil.toArray((String)head, ActTargetConfigEntity.class);
            targetConfigEntities2 = targetConfigEntities2 == null ? new ArrayList() : targetConfigEntities2;
            JSONObject object = new JSONObject();
            targetConfigEntities2.forEach(item -> {
                String key = item.getFiled();
                String value = item.getDefaultValue();
                String string = value = value == null ? "" : value;
                if (StringUtil.isNotBlank((CharSequence)key)) {
                    object.put(key, (Object)value);
                }
            });
            jsonArray.add((Object)object);
            actTargetVo.setItems((List)jsonArray);
        }
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteHead"})
    @ResponseBody
    public AjaxJson deleteHead(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.actProjectService.deleteHead(id);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        Map<String, Object> variablesTemp;
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("callback_service", "tpmProjectActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        if (this.ttActProjectActivitiVariablesExtend != null && (variablesTemp = this.ttActProjectActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo)) != null) {
            variables.putAll(variablesTemp);
        }
        String json = null;
        json = this.actProjectActivitiTargetTextExtend != null ? this.actProjectActivitiTargetTextExtend.createActivitiTargetText(entity, vo) : this.actProjectService.getTargetData(vo.getBusinessObjId(), vo.getProcessKey());
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(vo.getBusinessObjId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
        return ajaxJson;
    }

    @RequestMapping(value={"getActProjectTargets"})
    @ResponseBody
    public AjaxJson<ActTargetContentObjVo> getActProjectTargets(String processKey) {
        AjaxJson<ActTargetContentObjVo> ajaxJson = this.actProjectService.getActProjectTargets(processKey);
        return ajaxJson;
    }

    @RequestMapping(value={"getBpmKeys"})
    @ResponseBody
    public AjaxJson<TaProcessEntity> saveActProjectTargets(String processPage) {
        UserRedis userRedis = UserUtils.getUser();
        AjaxJson json = new AjaxJson();
        List orgVos = this.tmOrgFeign.getOrgListByUser(userRedis.getId(), null).getObjList();
        if (CollectionUtil.listEmpty((List)orgVos) || StringUtil.isBlank((CharSequence)processPage)) {
            json.setSuccess(false);
            json.setMsg("processPage \u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List orgTypes = orgVos.stream().map(TmOrgVo::getOrgType).collect(Collectors.toList());
            List bpmKeys = this.taProcessOrgPageFeign.getBpmKey(processPage, orgTypes).getObjList();
            List taProcessEntities = this.taProcessFeign.getTaProcessEntityByProcessKey(bpmKeys).getObjList();
            json.setObjList(taProcessEntities);
        }
        return json;
    }
}

