/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.plans.service.impl;

import com.biz.eisp.act.plans.dao.TtSalesPlansDao;
import com.biz.eisp.act.plans.entity.TreeGridModel;
import com.biz.eisp.act.plans.entity.TtSalesPlansEntity;
import com.biz.eisp.act.plans.service.TtSalesPlansService;
import com.biz.eisp.act.plans.vo.TtSalesPlansVo;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCustPostFeign;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttSalesPlansService")
@Transactional
public class TtSalesPlansServiceImplImpl
extends BaseServiceImpl<TtSalesPlansEntity>
implements TtSalesPlansService {
    @Autowired
    private TtSalesPlansDao ttSalesPlansDao;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TtCustPostFeign ttCustPostFeign;

    @Override
    public List<TtSalesPlansVo> findTtSalesPlansList(TtSalesPlansVo vo) {
        return this.ttSalesPlansDao.findTtSalesPlansList(vo);
    }

    @Override
    public PageInfo<TtSalesPlansVo> findTtSalesPlansPage(TtSalesPlansVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttSalesPlansDao.findTtSalesPlansList(vo), (Page)page);
    }

    @Override
    public TtSalesPlansEntity getTtSalesPlansEntity(String id) {
        return (TtSalesPlansEntity)this.ttSalesPlansDao.selectByPrimaryKey(id);
    }

    @Override
    public List<TtSalesPlansEntity> getTtSalesPlansEntity(TtSalesPlansVo vo) throws Exception {
        Example inexample = new Example(TtSalesPlansEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.ttSalesPlansDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtSalesPlansServiceImplImpl.class)
    public void save(TtSalesPlansVo vo) throws Exception {
        TtSalesPlansEntity entity = new TtSalesPlansEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            this.insertSelective(entity);
            if (StringUtil.isNotEmpty((CharSequence)vo.getCustomerCode())) {
                this.ttCustPostFeign.saveCustTermPost(entity.getId(), vo.getCustomerCode(), null);
            }
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtSalesPlansServiceImplImpl.class)
    public void update(TtSalesPlansVo vo) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            TtSalesPlansEntity entity = (TtSalesPlansEntity)this.ttSalesPlansDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
            if (StringUtil.isNotEmpty((CharSequence)vo.getCustomerCode())) {
                this.ttCustPostFeign.saveCustTermPost(vo.getId(), vo.getCustomerCode(), null);
            }
        }
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtSalesPlansServiceImplImpl.class)
    public boolean delete(String id) {
        int i = this.ttSalesPlansDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public List<TreeGrid> getTmOrgEntityGrid(String orgId, String orgCode) {
        AjaxJson ajaxJson = this.mdmApiFeign.getOrgList(orgId, orgCode);
        List orgEntities = ajaxJson.getObjList();
        List<TreeGrid> treeGrids = null;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)orgEntities)) {
            treeGrids = this.treeGridModel(orgEntities);
        }
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmOrgVo> orgList) {
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgCode");
        treeGridModel.setSrc("orgName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setFunctionType("orgType");
        treeGridModel.setIdField("id");
        treeGridModel.setParentText("orgDesc");
        treeGridModel.setChildList("tmOrgList");
        List<TreeGrid> treeGrids = this.treegrid(orgList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                String text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getParentText())) {
                String orgDesc = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getParentText()));
                tg.setParentText(orgDesc);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues((String)treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TagUtil.fieldNametoValues((String)treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    @Override
    public List<TreeGrid> findTmOrgList(TmOrgVo tmOrgEntity) {
        List<TreeGrid> treeGrids = null;
        String orgId = tmOrgEntity.getId();
        String orgCode = tmOrgEntity.getOrgCode();
        AjaxJson ajaxJson = null;
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            ajaxJson = this.mdmApiFeign.getOrgList(orgId, orgCode);
            if (ajaxJson != null) {
                for (TmOrgVo orgEntity : ajaxJson.getObjList()) {
                    treeGrids = this.treeGridModel(orgEntity.getTmOrgList());
                }
            }
        } else {
            ajaxJson = this.mdmApiFeign.getOrgList(orgId, orgCode);
            if (ajaxJson != null) {
                treeGrids = this.treeGridModel(ajaxJson.getObjList());
            }
        }
        return treeGrids;
    }
}

