/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.dao.TtActDetailGiftDao;
import com.biz.eisp.act.dao.TtActProductDao;
import com.biz.eisp.act.departcost.service.TtActDepartCostActivitiCallExtend;
import com.biz.eisp.act.departuse.service.TtActDepartUseActivitiCallExtend;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActDetailGiftEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.physical.service.TtActPhysicalActivitiCallExtend;
import com.biz.eisp.act.price.service.TtActPriceActivitiCallExtend;
import com.biz.eisp.act.project.service.ActProjectActivitiCallExtend;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.quota.service.TtActQuotaActivitiCallExtend;
import com.biz.eisp.act.service.ActEndService;
import com.biz.eisp.act.service.ActSaveCheckDataExpand;
import com.biz.eisp.act.service.ActfindTtActPageExtend;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActListReq;
import com.biz.eisp.act.vo.ActPriceActivitiVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActProductVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.TtBudgetSubjectsFeign;
import com.biz.eisp.budget.config.TtCostTypeCategoriesFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.fee.TtBudgetDetailFeign;
import com.biz.eisp.budget.fee.TtFeeBudgetFeign;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.act.ActData;
import com.biz.eisp.pay.audit.AuditActFeign;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtActServiceImplImpl
extends BaseServiceImpl<TtActEntity>
implements TtActService {
    @Autowired
    private TtActDao ttActQuotaDao;
    @Autowired
    private TtActDetailDao ttActQuotaDetailDao;
    @Autowired
    private TtActProductDao ttActQuotaProductDao;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private ActEndService actEndService;
    @Autowired
    private TtBudgetDetailFeign ttBudgetDetailFeign;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private TtFeeBudgetFeign ttFeeBudgetFeign;
    @Autowired
    private TtBudgetSubjectsFeign ttBudgetSubjectsFeign;
    @Autowired(required=false)
    private TtActQuotaActivitiCallExtend ttActQuotaActivitiCallExtend;
    @Autowired(required=false)
    private ActProjectActivitiCallExtend actProjectActivitiCallExtend;
    @Autowired(required=false)
    private TtActPriceActivitiCallExtend ttActPriceActivitiCallExtend;
    @Autowired(required=false)
    private TtActPhysicalActivitiCallExtend ttActPhysicalActivitiCallExtend;
    @Autowired(required=false)
    private TtActDepartUseActivitiCallExtend ttActDepartUseActivitiCallExtend;
    @Autowired(required=false)
    private TtActDepartCostActivitiCallExtend ttActDepartCostActivitiCallExtend;
    @Autowired(required=false)
    private ActSaveCheckDataExpand actSaveCheckDataExpand;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired
    private TtCostTypeCategoriesFeign ttCostTypeCategoriesFeign;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private ActfindTtActPageExtend actfindTtActPageExtend;
    @Autowired
    private AuditActFeign auditActFeign;
    @Autowired
    private TtActDetailGiftDao ttActDetailGiftDao;

    @Override
    public PageInfo<TtActVo> findTtActPage(TtActVo vo, Page page) {
        List authEntities;
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String temp;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap auMap = new HashMap();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put(parentId, list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"tta.org_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append(" tta.org_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("position")) {
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            List posCode = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                            if (!CollectionUtil.listNotEmptyNotSizeZero((List)posCode)) {
                                posCode.add("_");
                            }
                            temp = SqlUtil.setSqlIn500((List)posCode, (String)"tta.position_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            buffer.append("  tta.position_code = '" + userRedis.getPosCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (this.actfindTtActPageExtend != null) {
                        String expandSql = this.actfindTtActPageExtend.findTtActPageExtend();
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttActQuotaDao.findTtActList(vo, aUsql), (Page)page);
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailPage(TtActDetailVo vo, Page page) {
        List<TtActDetailVo> ttActDetailVos = this.ttActQuotaDetailDao.findTtActDetailList(vo);
        PageInfo info = PageAutoHelperUtil.generatePage(() -> ttActDetailVos, (Page)page);
        this.buildfindStr((PageInfo<TtActDetailVo>)info);
        return info;
    }

    private void buildfindStr(PageInfo<TtActDetailVo> info) {
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtActServiceImplImpl.class)
    public boolean save(TtActVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getTempUuid())) {
            return false;
        }
        TtActEntity entity = new TtActEntity();
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8f6c\u5316\u5f02\u5e38");
        }
        this.checkActHead(entity);
        entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
        entity.setActCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.insertSelective(entity);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List details = this.ttActQuotaDetailDao.selectByExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            throw new BusinessException("\u672a\u6dfb\u52a0\u6d3b\u52a8\u660e\u7ec6,\u4e0d\u80fd\u4fdd\u5b58");
        }
        details.stream().filter(dl -> StringUtils.isBlank((CharSequence)dl.getActDetailCode())).forEach(item -> {
            item.setActCode(entity.getActCode());
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setActDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota_detail.name()).toString());
        });
        this.ttActQuotaDetailDao.updateBatchByPrimaryKeySelective(details);
        BigDecimal amount = BigDecimal.ZERO;
        for (TtActDetailEntity item2 : details) {
            amount = amount.add(item2.getAmount() == null ? BigDecimal.ZERO : item2.getAmount());
        }
        this.ttActQuotaDao.updateActHeadAmount(amount, entity.getId());
        int need = this.ttActDetailService.checkShareProduct(vo.getTempUuid());
        if (need > 0) {
            String productId = vo.getProductJson();
            List productVos = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)productId)) {
                productVos = JSONArray.parseArray((String)productId, TtActProductVo.class);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(productVos)) {
                ArrayList products = new ArrayList();
                productVos.stream().forEach(item -> {
                    TtActProductEntity productEntity = new TtActProductEntity();
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)productEntity);
                        productEntity.setActCode(entity.getActCode());
                        productEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                        products.add(productEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException("\u8f6c\u5316\u5f02\u5e38");
                    }
                });
                this.ttActQuotaProductDao.insertList(products);
            } else {
                throw new BusinessException("\u5206\u644a\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        vo.setId(entity.getId());
        this.saveJson(vo);
        return true;
    }

    private void checkActHead(TtActEntity entity) {
        if (this.actSaveCheckDataExpand != null) {
            this.actSaveCheckDataExpand.checkActHeadData(entity);
            return;
        }
        this.checkActHeadData(entity);
    }

    @Override
    public void checkActHeadData(TtActEntity entity) {
        ArrayList<String> budgetCodes = new ArrayList<String>();
        budgetCodes.add(entity.getBudgetCode());
        List costTypeCategoriesEntities = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeCategoriesFeign.chooseTypeList(budgetCodes));
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)costTypeCategoriesEntities)) {
            throw new BusinessException("\u6240\u9009\u9884\u7b97\u65e0\u4efb\u4f55\u6d3b\u52a8\u5927\u7c7b\u53ef\u4ee5\u9009\u62e9");
        }
        Map<String, TtCostTypeCategoriesEntity> mapType = costTypeCategoriesEntities.stream().collect(Collectors.toMap(TtCostTypeCategoriesEntity::getCategoriesCode, item -> item));
        if (!mapType.containsKey(entity.getCategoriesCode())) {
            throw new BusinessException("\u6d3b\u52a8\u5927\u7c7b\uff1a" + entity.getCategoriesName() + " \u4e0d\u5c5e\u4e8e\u6240\u9009\u9884\u7b97");
        }
    }

    @Override
    public PageInfo<TtActDetailEntity> list(ActListReq actListReq) {
        Page page = new Page();
        page.setPage(actListReq.getPageNum());
        page.setRows(actListReq.getPageSize());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttActQuotaDao.list(actListReq.getActDetailCode()), (Page)page);
        return pageInfo;
    }

    @Override
    public void updateProcessKey(TtActVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getId())) {
            return;
        }
        TtActEntity entity = new TtActEntity();
        entity.setId(vo.getId());
        entity.setProcessKey(vo.getProcessKey());
        entity.setApplyUserBy(vo.getApplyUserBy());
        entity.setApplyTime(vo.getApplyTime());
        entity.setApplyUserName(vo.getApplyUserName());
        this.updateByPrimaryKeySelective(entity);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtActServiceImplImpl.class)
    public boolean update(TtActVo vo) {
        TtActEntity entity = (TtActEntity)this.selectByPrimaryKey(vo.getId());
        if (StringUtils.isBlank((CharSequence)entity.getTempUuid())) {
            return false;
        }
        if (!(entity.getBpmStatus().equals(ConstantEnum.bpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.REJECT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.BACK.getValue()))) {
            throw new RuntimeException("\u6570\u636e\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8f6c\u5316\u5f02\u5e38");
        }
        UserRedis userRedis = UserUtils.getUser();
        entity.setUpdateName(userRedis.getRealname());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm");
        entity.setUpdateDate(sdf.format(new Date()));
        this.checkActHead(entity);
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.updateByPrimaryKeySelective(entity);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List details = this.ttActQuotaDetailDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            details.forEach(item -> {
                item.setActCode(entity.getActCode());
                item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                if (StringUtils.isBlank((CharSequence)item.getActDetailCode())) {
                    item.setActDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota_detail.name()).toString());
                }
            });
            this.ttActQuotaDetailDao.updateBatchByPrimaryKeySelective(details);
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (TtActDetailEntity item2 : details) {
            amount = amount.add(item2.getAmount() == null ? BigDecimal.ZERO : item2.getAmount());
        }
        this.ttActQuotaDao.updateActHeadAmount(amount, entity.getId());
        Example example_ = new Example(TtActProductEntity.class);
        Example.Criteria criteria_ = example.createCriteria();
        criteria_.andEqualTo("actCode", (Object)entity.getActCode());
        this.ttActQuotaProductDao.deleteByExample(example_);
        int need = this.ttActDetailService.checkShareProduct(vo.getTempUuid());
        if (need > 0) {
            String proJson = vo.getProductJson();
            List productVos = JsonPropertyUtil.toArray((String)proJson, TtActProductVo.class);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)productVos)) {
                ArrayList products = new ArrayList();
                productVos.stream().forEach(item -> {
                    TtActProductEntity productEntity = new TtActProductEntity();
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)productEntity);
                        productEntity.setActCode(entity.getActCode());
                        productEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                        products.add(productEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.ttActQuotaProductDao.insertList(products);
            } else {
                throw new BusinessException("\u5206\u644a\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        this.saveJson(vo);
        return true;
    }

    private void saveJson(TtActVo vo) {
        if (vo != null && StringUtil.isNotBlank((CharSequence)vo.getHeadTarget()) && StringUtil.isNotBlank((CharSequence)vo.getItemTarget())) {
            String headTarget = vo.getHeadTarget();
            headTarget = StringUtil.isNotBlank((CharSequence)headTarget) ? StringEscapeUtils.unescapeJava((String)headTarget) : headTarget;
            headTarget = headTarget.replaceFirst("\"", "");
            headTarget = headTarget.substring(0, headTarget.lastIndexOf("\""));
            String itemTarget = vo.getItemTarget();
            itemTarget = StringUtil.isNotBlank((CharSequence)itemTarget) ? StringEscapeUtils.unescapeJava((String)itemTarget) : itemTarget;
            itemTarget = itemTarget.replaceFirst("\"", "");
            itemTarget = itemTarget.substring(0, itemTarget.lastIndexOf("\""));
            this.actCommonService.saveActProjectTargets(vo.getId(), vo.getProcessKeyTemp(), headTarget, itemTarget);
        }
    }

    @Override
    public TtActEntity getTtActVoByActCode(String actCode) {
        TtActEntity ttActEntity = null;
        Example example = new Example(TtActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actCode);
        List entities = this.ttActQuotaDao.selectByExample(example);
        if (entities != null && entities.size() > 0) {
            ttActEntity = (TtActEntity)entities.get(0);
        }
        return ttActEntity;
    }

    @Override
    public List<TtActVo> findTtActList(TtActVo vo) {
        return this.ttActQuotaDao.findTtActList(vo, null);
    }

    @Override
    public PageInfo<TtActVo> findTtActListForAdvance(TtActVo vo, Page page) {
        vo.setActType(ConstantEnum.ACTTYPE.quota.getVal());
        vo.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        List entities = DictUtil.getDictList((String)"pay_type");
        ArrayList<String> payType = new ArrayList<String>();
        payType.add("_");
        String pay_type_code = "pay_type_code";
        String pay_type = "BILL";
        if (entities != null) {
            entities.forEach(item -> {
                Map extendMap = item.getExtendMap();
                if (extendMap != null && extendMap.containsKey(pay_type_code) && extendMap.get(pay_type_code) != null && StringUtils.equals((CharSequence)pay_type, (CharSequence)extendMap.get(pay_type_code).toString())) {
                    payType.add(item.getDictCode());
                }
            });
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttActQuotaDao.findTtActListForAdvance(vo, payType), (Page)page);
    }

    @Override
    public void doQuotaBpmStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        if (this.ttActQuotaActivitiCallExtend != null) {
            this.ttActQuotaActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void doDepartCostCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        if (this.ttActDepartCostActivitiCallExtend != null) {
            this.ttActDepartCostActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void doActPriceCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        if (this.ttActPriceActivitiCallExtend != null) {
            this.ttActPriceActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void doPhysicalCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        if (this.ttActPhysicalActivitiCallExtend != null) {
            this.ttActPhysicalActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void doDepartUseCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        if (this.ttActDepartUseActivitiCallExtend != null) {
            this.ttActDepartUseActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public AjaxJson updateTtActBpmStatus(String status, String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)status)) {
            return ajaxJson;
        }
        ajaxJson = this.doUseBuget(status, id);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActEntity ttActEntity = new TtActEntity();
        ttActEntity.setBpmStatus(status);
        ttActEntity.setId(id);
        if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)status)) {
            ttActEntity.setApplyTime(DateUtils.dateNow2Str());
        }
        this.ttActQuotaDao.updateByPrimaryKeySelective(ttActEntity);
        if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.PASS.getValue(), (CharSequence)status)) {
            ApiResultUtil.objResult((AjaxJson)this.auditActFeign.saveActData(this.createActData(id)));
        }
        return ajaxJson;
    }

    private ActData createActData(String id) {
        ActData actData = new ActData();
        String actCode = "actCode";
        TtActEntity ttActEntity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(id);
        Example exampleDetail = new Example(TtActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo(actCode, (Object)ttActEntity.getActCode());
        List detailEntities = this.ttActQuotaDetailDao.selectByExample(exampleDetail);
        detailEntities.forEach(item -> {
            item.setAuditAmount(BigDecimal.ZERO);
            item.setAuditStatus("0");
        });
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(ttActEntity.getActCode());
        List<TtActbudgetEntity> budgets = this.ttActbudgetService.getActbudgetsByCodes(codes);
        Example exampleProduct = new Example(TtActProductEntity.class);
        Example.Criteria criteriaProduct = exampleProduct.createCriteria();
        criteriaProduct.andEqualTo(actCode, (Object)ttActEntity.getActCode());
        List products = this.ttActQuotaProductDao.selectByExample(exampleProduct);
        ArrayList<String> detailCodes = new ArrayList<String>();
        for (TtActDetailEntity item2 : detailEntities) {
            detailCodes.add(item2.getActDetailCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(detailCodes)) {
            Example exampleDetailGift = new Example(TtActDetailGiftEntity.class);
            Example.Criteria criteriaDetailGift = exampleDetailGift.createCriteria();
            criteriaDetailGift.andIn("actDetailCode", detailCodes);
            List gifts = this.ttActDetailGiftDao.selectByExample(exampleDetailGift);
            actData.setGifts(gifts);
        }
        actData.setBudgets(budgets);
        actData.setHead(ttActEntity);
        actData.setDetails(detailEntities);
        actData.setProducts(products);
        return actData;
    }

    private AjaxJson doUseBuget(String bpmStatus2, String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (!(StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)bpmStatus2) || StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.REJECT.getValue(), (CharSequence)bpmStatus2) || StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.BACK.getValue(), (CharSequence)bpmStatus2) || StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.COMMIT.getValue(), (CharSequence)bpmStatus2))) {
            return ajaxJson;
        }
        TtActEntity ttActEntity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(id);
        if (ConstantEnum.ACTTYPE.quota.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u5b9a\u989d\u6d3b\u52a8");
        } else if (ConstantEnum.ACTTYPE.departuse.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u90e8\u95e8\u9886\u7528");
        } else if (ConstantEnum.ACTTYPE.price.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u4ef7\u683c\u6d3b\u52a8");
        } else if (ConstantEnum.ACTTYPE.phyis.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u5b9e\u7269\u8d39\u7528");
        } else if (ConstantEnum.ACTTYPE.departcost.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u90e8\u95e8\u8d39\u7528");
        } else if (ConstantEnum.ACTTYPE.project.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFeeProject(ajaxJson, ttActEntity, bpmStatus2, "\u9879\u76ee\u6d3b\u52a8");
        } else if (ConstantEnum.ACTTYPE.rebate.getVal().equals(ttActEntity.getActType())) {
            ajaxJson = this.doBugutFee(ajaxJson, ttActEntity, bpmStatus2, "\u8fd4\u5229\u6d3b\u52a8");
        }
        return ajaxJson;
    }

    private AjaxJson doBugutFee(AjaxJson ajaxJson, TtActEntity ttActEntity, String bpmStatus2, String actTypeName) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
        List detailEntities = this.ttActQuotaDetailDao.selectByExample(example);
        for (TtActDetailEntity item : detailEntities) {
            BigDecimal amount = item.getAmount() == null ? BigDecimal.ZERO : item.getAmount();
            FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
            feeUseBudgutParam.setBugetCode(ttActEntity.getBudgetCode());
            feeUseBudgutParam.setAmount(amount);
            feeUseBudgutParam.setFromAddress("tt_act");
            feeUseBudgutParam.setBusinessCode(ttActEntity.getActCode());
            feeUseBudgutParam.setBusinessCodeAttached(item.getActDetailCode());
            feeUseBudgutParam.setBusinessName(ttActEntity.getActName());
            feeUseBudgutParam.setCustName(item.getCustomerName());
            feeUseBudgutParam.setOrgName(item.getOrgName());
            if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)bpmStatus2)) {
                feeUseBudgutParam.setNote(actTypeName);
                feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
                ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
                if (ajaxJson.isSuccess()) continue;
                return ajaxJson;
            }
            feeUseBudgutParam.setNote(actTypeName);
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
            ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
        }
        return ajaxJson;
    }

    public void doBudgetForMax(List<TtActbudgetEntity> ttActbudgetEntities, List<TtFeeBudgetEntity> feeBudgetEntities) {
        Map<String, BigDecimal> maxMap = ttActbudgetEntities.stream().collect(Collectors.toMap(TtActbudgetEntity::getBudgetCode, TtActbudgetEntity::getShareAmount));
        feeBudgetEntities.forEach(item -> {
            String budgetCode = item.getBudgetCode();
            if (maxMap.containsKey(budgetCode) && ((BigDecimal)maxMap.get(budgetCode)).compareTo(item.getAmount()) < 0) {
                item.setAmount((BigDecimal)maxMap.get(budgetCode));
            }
        });
    }

    private TtFeeBudgetEntity checkIsNo(List<TtFeeBudgetEntity> entities, Map<String, Boolean> map) {
        if (CollectionUtil.listEmpty(entities)) {
            return null;
        }
        for (TtFeeBudgetEntity item : entities) {
            if (!map.containsKey(item.getBudgetSubjectsCode()) || map.get(item.getBudgetSubjectsCode()).booleanValue()) continue;
            return item;
        }
        return null;
    }

    public void doBugutFeeProjectDetail(Map<String, List<TtActDetailEntity>> actMap, Map<String, List<TtFeeBudgetEntity>> mapAct, List<TtFeeBudgetEntity> feeBudgetEntities, TtActEntity ttActEntity, String bpmStatus2, String actTypeName, AjaxJson ajaxJson) {
        List budgetSubjectsCodes = feeBudgetEntities.stream().map(TtFeeBudgetEntity::getBudgetSubjectsCode).collect(Collectors.toList());
        List subjectsEntities = ApiResultUtil.listResult((AjaxJson)this.ttBudgetSubjectsFeign.getListByCodes(budgetSubjectsCodes), (boolean)true);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        subjectsEntities.forEach(item -> {
            if (ConstantEnum.YesNoEnum.ZERO.getValue().equals(item.getIsBudgetControl())) {
                map.put(item.getBudgetSubjectsCode(), false);
            } else {
                map.put(item.getBudgetSubjectsCode(), true);
            }
        });
        for (Map.Entry<String, List<TtActDetailEntity>> tempMap : actMap.entrySet()) {
            List<TtFeeBudgetEntity> entities = mapAct.get(tempMap.getKey());
            TtFeeBudgetEntity tempBudgetNo = this.checkIsNo(entities, map);
            if (tempBudgetNo != null) {
                for (TtActDetailEntity item2 : tempMap.getValue()) {
                    this.doBudgetCommit(ajaxJson, tempBudgetNo.getBudgetCode(), ttActEntity, item2, bpmStatus2, actTypeName, item2.getAmount());
                }
                continue;
            }
            for (TtActDetailEntity item2 : tempMap.getValue()) {
                BigDecimal amount = item2.getAmount() == null ? BigDecimal.ZERO : item2.getAmount();
                if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (CollectionUtil.listNotEmptyNotSizeZero(feeBudgetEntities)) {
                    for (int i = 0; i < feeBudgetEntities.size(); ++i) {
                        if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        TtFeeBudgetEntity tempBudget = feeBudgetEntities.get(i);
                        BigDecimal amountTemp = tempBudget.getAmount();
                        if (amountTemp.compareTo(amount) >= 0) {
                            this.doBudgetCommit(ajaxJson, tempBudget.getBudgetCode(), ttActEntity, item2, bpmStatus2, actTypeName, item2.getAmount());
                            amountTemp = amountTemp.subtract(amount);
                            amount = BigDecimal.ZERO;
                            if (amountTemp.compareTo(BigDecimal.ZERO) == 0) {
                                feeBudgetEntities.remove(i);
                                --i;
                                continue;
                            }
                            tempBudget.setAmount(amountTemp);
                            continue;
                        }
                        this.doBudgetCommit(ajaxJson, tempBudget.getBudgetCode(), ttActEntity, item2, bpmStatus2, actTypeName, item2.getAmount());
                        feeBudgetEntities.remove(i);
                        --i;
                        amount = amount.subtract(amountTemp);
                    }
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    throw new BusinessException(item2.getCategoriesName() + "\u53ef\u4ee5\u4f7f\u7528\u9884\u7b97\u4e0d\u8db3");
                }
                throw new BusinessException(item2.getCategoriesName() + "\u53ef\u4ee5\u4f7f\u7528\u9884\u7b97\u4e0d\u8db3");
            }
        }
    }

    public void doBudgetCommit(AjaxJson ajaxJson, String budgetCode, TtActEntity ttActEntity, TtActDetailEntity item, String bpmStatus2, String actTypeName, BigDecimal amount) {
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(budgetCode);
        feeUseBudgutParam.setAmount(amount);
        feeUseBudgutParam.setFromAddress("tt_act");
        feeUseBudgutParam.setBusinessCode(ttActEntity.getActCode());
        feeUseBudgutParam.setBusinessName(ttActEntity.getActName());
        feeUseBudgutParam.setBusinessCodeAttached(item.getActDetailCode());
        feeUseBudgutParam.setCustName(item.getCustomerName());
        feeUseBudgutParam.setOrgName(item.getOrgName());
        if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)bpmStatus2)) {
            feeUseBudgutParam.setNote(actTypeName);
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
            ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
        } else {
            feeUseBudgutParam.setNote(actTypeName);
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
            ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
        }
    }

    private AjaxJson doBugutFeeProject(AjaxJson ajaxJson, TtActEntity ttActEntity, String bpmStatus2, String actTypeName) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
        List detailEntities = this.ttActQuotaDetailDao.selectByExample(example);
        HashMap<String, List<TtActDetailEntity>> detailMap = new HashMap<String, List<TtActDetailEntity>>();
        detailEntities.stream().collect(Collectors.groupingBy(TtActDetailEntity::getCategoriesCode, Collectors.toList())).forEach((parentId, list) -> detailMap.put((String)parentId, (List<TtActDetailEntity>)list));
        ArrayList<String> actCodes = new ArrayList<String>();
        actCodes.add(ttActEntity.getActCode());
        List<TtActbudgetEntity> ttActbudgetEntities = this.ttActbudgetService.getActbudgetsByCodes(actCodes);
        List budgetCodes = null;
        budgetCodes = ttActbudgetEntities.stream().map(TtActbudgetEntity::getBudgetCode).collect(Collectors.toList());
        List feeBudgetEntities = ApiResultUtil.listResult((AjaxJson)this.ttFeeBudgetFeign.getEntityByCodes(budgetCodes), (boolean)true);
        List costTypeCategoriesEntities = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeCategoriesFeign.chooseTypeList(budgetCodes), (boolean)true);
        Map<String, List<TtFeeBudgetEntity>> mapAct = this.createActBudget(feeBudgetEntities, costTypeCategoriesEntities);
        this.doBugutFeeProjectDetail(detailMap, mapAct, feeBudgetEntities, ttActEntity, bpmStatus2, actTypeName, ajaxJson);
        return ajaxJson;
    }

    private Map<String, List<TtFeeBudgetEntity>> createActBudget(List<TtFeeBudgetEntity> feeBudgetEntities, List<TtCostTypeCategoriesEntity> costTypeCategoriesEntities) {
        HashMap<String, List<TtFeeBudgetEntity>> map = new HashMap<String, List<TtFeeBudgetEntity>>();
        HashMap budgetListMap = new HashMap();
        feeBudgetEntities.stream().collect(Collectors.groupingBy(TtFeeBudgetEntity::getBudgetSubjectsCode, Collectors.toList())).forEach((parentId, list) -> budgetListMap.put(parentId, list));
        for (TtCostTypeCategoriesEntity item : costTypeCategoriesEntities) {
            String budgetSubjectsCode = item.getBudgetSubjectsCode();
            map.put(item.getCategoriesCode(), (List<TtFeeBudgetEntity>)budgetListMap.get(budgetSubjectsCode));
        }
        return map;
    }

    @Override
    public void updateAuditStatus(List<String> detailCode) {
        List<TtActDetailEntity> actDetailEntities = this.ttActDetailService.findDetailByCodes(detailCode);
        List<String> actCode = actDetailEntities.stream().map(TtActDetailEntity::getActCode).distinct().collect(Collectors.toList());
        List<TtActDetailEntity> actDetailAll = this.ttActDetailService.findDetailByActCodes(actCode);
        HashMap<String, List> detailMap = new HashMap<String, List>();
        actDetailAll.stream().collect(Collectors.groupingBy(TtActDetailEntity::getActCode, Collectors.toList())).forEach((actCodeTemp, list) -> detailMap.put((String)actCodeTemp, (List)list));
        detailMap.forEach((k, v) -> {
            boolean flag = true;
            Example example = new Example(TtActEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actCode", k);
            TtActEntity entity = new TtActEntity();
            for (TtActDetailEntity item : v) {
                if (!ConstantEnum.YesNoEnum.ZERO.getValue().equals(item.getAuditStatus())) continue;
                flag = false;
            }
            if (flag) {
                entity.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
            } else {
                entity.setAuditStatus(ConstantEnum.YesNoEnum.ZERO.getValue());
            }
            this.ttActQuotaDao.updateByExampleSelective(entity, example);
        });
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtActServiceImplImpl.class)
    public AjaxJson delete(String id) {
        AjaxJson j = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(id);
        if (entity.getBpmStatus().equals(ConstantEnum.bpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.REJECT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.BACK.getValue())) {
            int i = this.ttActQuotaDao.deleteByPrimaryKey(id);
            if (i > 0) {
                this.ttActDetailService.deleteDetailByActCode(entity.getActCode());
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u5ba1\u6279\u4e2d\u6216\u8005\u5ba1\u6279\u901a\u8fc7\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        return j;
    }

    @Override
    public List<TtActEntity> getActEntitys(List<String> codes) {
        Example example = new Example(TtActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actCode", codes);
        return this.ttActQuotaDao.selectByExample(example);
    }

    @Override
    public void doProjectActCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        TtActEntity entity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(activitiCallBackVo.getBusinessObjId());
        entity.setBpmStatus(activitiCallBackVo.getBpmStatus());
        this.ttActQuotaDao.updateByPrimaryKeySelective(entity);
        if (!ConstantEnum.bpmStatus.PASS.getValue().equals(activitiCallBackVo.getBpmStatus())) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
        }
        if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.PASS.getValue(), (CharSequence)activitiCallBackVo.getBpmStatus())) {
            ApiResultUtil.objResult((AjaxJson)this.auditActFeign.saveActData(this.createActData(activitiCallBackVo.getBusinessObjId())));
        }
        if (this.actProjectActivitiCallExtend != null) {
            this.actProjectActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void doRebateActCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
        this.actEndService.actEnd(activitiCallBackVo.getBusinessObjId());
        if (this.ttActPhysicalActivitiCallExtend != null) {
            this.ttActPhysicalActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public String getTargetDataForPrice(String id) {
        TtActEntity actEntity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(id);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actEntity.getActCode());
        List detailEntities = this.ttActQuotaDetailDao.selectByExample(example);
        ArrayList<ActPriceActivitiVo> actPriceActivitiVos = new ArrayList<ActPriceActivitiVo>();
        ActPriceActivitiVo actPriceActivitiVo = new ActPriceActivitiVo();
        actPriceActivitiVo.setActName(actEntity.getActName());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal forecastSalesNum = BigDecimal.ZERO;
        BigDecimal forecastSalesAmount = BigDecimal.ZERO;
        for (TtActDetailEntity item : detailEntities) {
            amount = amount.add(item.getAmount());
            forecastSalesNum = forecastSalesNum.add(item.getForecastSalesNum() == null ? BigDecimal.ZERO : new BigDecimal(item.getForecastSalesNum()));
            forecastSalesAmount = forecastSalesAmount.add(item.getForecastSalesAmount() == null ? BigDecimal.ZERO : item.getForecastSalesAmount());
        }
        String actRatio = amount.divide(forecastSalesAmount, 4, 4).multiply(new BigDecimal(100)).toString();
        actPriceActivitiVo.setActRatio(actRatio);
        actPriceActivitiVo.setAllRatio("");
        actPriceActivitiVo.setAmount(amount.toString());
        actPriceActivitiVo.setForecastSalesNum(forecastSalesNum.toString());
        actPriceActivitiVo.setForecastSalesAmount(forecastSalesAmount.toEngineeringString());
        TtFeeBudgetEntity budgetEntity = (TtFeeBudgetEntity)ApiResultUtil.objResult((AjaxJson)this.ttFeeBudgetFeign.getEntity(null, actEntity.getBudgetCode()));
        actPriceActivitiVo.setBudgetAmount(budgetEntity.getAmount() == null ? "" : budgetEntity.getAmount().toString());
        actPriceActivitiVos.add(actPriceActivitiVo);
        String json = JSONArray.toJSONString(actPriceActivitiVos);
        return json;
    }

    @Override
    public List<TtActEntity> getActEntitysByDetailCode(List<String> codes) {
        List<TtActEntity> actEntities = this.ttActQuotaDao.getActEntitysByDetailCode(codes);
        return actEntities;
    }
}

