/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.api.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActFineEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActFineService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActListReq;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.TtAuditActFeign;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RequestMapping(value={"ttApiActController"})
@RestController
public class TtApiActController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtAuditActFeign ttAuditActFeign;
    @Autowired
    private TtActFineService ttActFineService;

    @GetMapping(value={"selectByPrimaryKey"})
    public AjaxJson<TtActEntity> selectByPrimaryKey(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getTtActVoByActCode"})
    public AjaxJson<TtActEntity> getTtActVoByActCode(@RequestParam(value="actCode") String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = this.ttActService.getTtActVoByActCode(actCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"updateAuditStatus"})
    public AjaxJson updateAuditStatus(@RequestParam(value="detailCode") List<String> detailCode) {
        AjaxJson ajaxJson = new AjaxJson();
        this.ttActService.updateAuditStatus(detailCode);
        return ajaxJson;
    }

    @GetMapping(value={"getActEntitys"})
    public AjaxJson<TtActEntity> getActEntitys(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entitys = this.ttActService.getActEntitys(codes);
        ajaxJson.setObjList(entitys);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtActDetailPage"})
    public List<TtActDetailVo> findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = null;
        ArrayList<TtActDetailVo> ttActDetailVos = new ArrayList<TtActDetailVo>();
        List actEntities = ApiResultUtil.listResult((AjaxJson)this.ttAuditActFeign.getActCodeByTempId(vo.getTempUuid()), (boolean)true);
        List<String> actCodes = new ArrayList<String>();
        actCodes.add("_");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
            actCodes = actEntities.stream().map(TtAuditActEntity::getActCode).collect(Collectors.toList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(info = this.ttActDetailService.findTtActDetailByActsPage(vo, (Page)page, actCodes)).getList())) {
            info.getList().forEach(item -> {
                TtCostTypeFineEntity ttCostTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, item.getActSubclassCode()).getObj();
                if (ttCostTypeFineEntity != null && StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getActMethodCode()) && (StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.DDFY.getValue()) || StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.HFFY.getValue()))) {
                    item.setCategoriesCode(ttCostTypeFineEntity.getCategoriesCode());
                    item.setCategoriesName(ttCostTypeFineEntity.getCategoriesName());
                    String isMultipleAudit = StringUtil.isEmpty((String)ttCostTypeFineEntity.getIsMultipleAudit()) ? "0" : ttCostTypeFineEntity.getIsMultipleAudit();
                    item.setIsMultipleAudit(isMultipleAudit);
                    ttActDetailVos.add((TtActDetailVo)item);
                }
            });
        }
        return ttActDetailVos;
    }

    @RequestMapping(value={"findTtActAdvanceList"})
    public DataGrid findTtActAdvanceList(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> ttActVos = this.ttActService.findTtActListForAdvance(vo, (Page)page);
        return new DataGrid(ttActVos);
    }

    @GetMapping(value={"getActEntitysByDetailCode"})
    public AjaxJson<TtActEntity> getActEntitysByDetailCode(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entities = this.ttActService.getActEntitysByDetailCode(codes);
        ajaxJson.setList(entities);
        return ajaxJson;
    }

    @PostMapping(value={"saveOrUpdateActFine"})
    AjaxJson<TtActFineEntity> saveOrUpdateActFine(@RequestBody TtActFineEntity actfine) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActDetailEntity detailEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(actfine.getId());
        detailEntity.setFineStr(actfine.getAuditMaterial());
        actfine.setId(null);
        this.ttActFineService.insertSelective(actfine);
        ajaxJson.setObj((Object)actfine);
        return ajaxJson;
    }

    @GetMapping(value={"findActFineList"})
    AjaxJson<TtActFineEntity> findActFineList(@RequestParam(value="actCode") String actCode, @RequestParam(value="actSubCode") String actSubCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtActFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actCode);
        criteria.andEqualTo("actSubclassCode", (Object)actSubCode);
        List list = this.ttActFineService.selectExample(example);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u7533\u8bf7\u672a\u6838\u9500\u660e\u7ec6\uff08\u5206\u9875\uff09")
    @RequestMapping(value={"list"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public PageInfo<TtActDetailEntity> list(@RequestBody ActListReq actListReq) {
        return this.ttActService.list(actListReq);
    }
}

