/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.project.service.impl;

import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.dao.TtActProductDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.project.dao.TtActbudgetDao;
import com.biz.eisp.act.project.service.ActProjectService;
import com.biz.eisp.act.project.service.ActprojectCheckSaveOrUpdateExtend;
import com.biz.eisp.act.project.service.TargetDataProjectExtendService;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentObjEntity;
import com.biz.eisp.activiti.vo.ActTargetContentObjVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.budget.config.TtCostTypeCategoriesFeign;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.project.vo.ActDetailSaveVo;
import com.biz.eisp.project.vo.ActProjectSaveVo;
import com.biz.eisp.tools.CodeRuleUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class ActProjectServiceImpl
implements ActProjectService {
    @Autowired
    private TtActDao ttActDao;
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtActProductDao ttActProductDao;
    @Autowired
    private TtActbudgetDao ttActbudgetDao;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtCostTypeCategoriesFeign ttCostTypeCategoriesFeign;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired(required=false)
    private ActprojectCheckSaveOrUpdateExtend actprojectCheckSaveOrUpdateExtend;
    @Autowired(required=false)
    private TargetDataProjectExtendService targetDataProjectExtendService;

    @Override
    public ActProjectSaveVo getActProjectSaveVoByCode(String code, String id) {
        ActProjectSaveVo actProjectSaveVo = new ActProjectSaveVo();
        TtActEntity head = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        Example exampleDetail = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = exampleDetail.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List detailEntities = this.ttActDetailDao.selectByExample(exampleDetail);
        Example exampleBudget = new Example(TtActbudgetEntity.class);
        Example.Criteria criteriaBudget = exampleBudget.createCriteria();
        criteriaBudget.andEqualTo("actCode", (Object)head.getActCode());
        List ttActbudgetEntities = this.ttActbudgetDao.selectByExample(exampleBudget);
        Example exampleProduct = new Example(TtActProductEntity.class);
        Example.Criteria criteriaProduct = exampleProduct.createCriteria();
        criteriaProduct.andEqualTo("actCode", (Object)head.getActCode());
        List productEntities = this.ttActProductDao.selectByExample(exampleProduct);
        actProjectSaveVo.setHead(head);
        actProjectSaveVo.setBudgets(ttActbudgetEntities);
        HashMap detailListMap = new HashMap();
        detailEntities.stream().collect(Collectors.groupingBy(TtActDetailEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> detailListMap.put(categoriesCode, list));
        HashMap productListMap = new HashMap();
        productEntities.stream().collect(Collectors.groupingBy(TtActProductEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> productListMap.put(categoriesCode, list));
        ArrayList codeDetail = new ArrayList(detailListMap.keySet());
        ArrayList productDetail = new ArrayList(productListMap.keySet());
        codeDetail.addAll(productDetail);
        List codes = codeDetail.stream().distinct().collect(Collectors.toList());
        List costTypeCategoriesEntities = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeFeign.findListByCodes(codes), (boolean)true);
        List categoriesCodes = costTypeCategoriesEntities.stream().map(TtCostTypeCategoriesEntity::getCategoriesCode).collect(Collectors.toList());
        List listAll = this.ttCostTypeFeign.findCategoriesExtendByCode(categoriesCodes).getObjList();
        HashMap<String, List> listMap = new HashMap<String, List>();
        listAll.stream().collect(Collectors.groupingBy(TtCostTypeCategoriesExtendEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> listMap.put((String)categoriesCode, (List)list));
        listMap.forEach((k, v) -> Collections.sort(v, Comparator.comparing(TtCostTypeCategoriesExtendEntity::getOrderNum)));
        ArrayList categories = new ArrayList();
        costTypeCategoriesEntities.forEach(item -> {
            ActDetailSaveVo vo = new ActDetailSaveVo();
            vo.setCategoriesCode(item.getCategoriesCode());
            vo.setCategoriesName(item.getCategoriesName());
            vo.setItems((List)detailListMap.get(item.getCategoriesCode()));
            vo.setProducts((List)productListMap.get(item.getCategoriesCode()));
            vo.setExtendEntities((List)listMap.get(item.getCategoriesCode()));
            categories.add(vo);
        });
        actProjectSaveVo.setCategories(categories);
        return actProjectSaveVo;
    }

    private void checkSaveOrUpdate(ActProjectSaveVo actProjectSaveVo, AjaxJson ajaxJson) {
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)actProjectSaveVo.getBudgets())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u9884\u7b97");
            return;
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)actProjectSaveVo.getCategories())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u6d3b\u52a8\u5927\u7c7b");
            return;
        }
        if (this.actprojectCheckSaveOrUpdateExtend != null) {
            this.actprojectCheckSaveOrUpdateExtend.checkSaveOrUpdate(actProjectSaveVo, ajaxJson);
        } else {
            this.checkSaveOrUpdateNormal(actProjectSaveVo, ajaxJson);
        }
    }

    @Override
    public void checkSaveOrUpdateNormal(ActProjectSaveVo actProjectSaveVo, AjaxJson ajaxJson) {
        List budgetCodes = actProjectSaveVo.getBudgets().stream().map(TtActbudgetEntity::getBudgetCode).distinct().collect(Collectors.toList());
        List costTypeCategoriesEntities = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeCategoriesFeign.chooseTypeList(budgetCodes));
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)costTypeCategoriesEntities)) {
            ajaxJson.setErrMsg("\u6240\u9009\u9884\u7b97\u65e0\u4efb\u4f55\u6d3b\u52a8\u5927\u7c7b\u53ef\u4ee5\u9009\u62e9");
            return;
        }
        Map<String, TtCostTypeCategoriesEntity> mapType = costTypeCategoriesEntities.stream().collect(Collectors.toMap(TtCostTypeCategoriesEntity::getCategoriesCode, item -> item));
        for (ActDetailSaveVo actDetailSaveVo : actProjectSaveVo.getCategories()) {
            if (mapType.containsKey(actDetailSaveVo.getCategoriesCode())) continue;
            ajaxJson.setErrMsg("\u6d3b\u52a8\u5927\u7c7b\uff1a" + actDetailSaveVo.getCategoriesName() + " \u4e0d\u5c5e\u4e8e\u6240\u9009\u9884\u7b97");
            return;
        }
    }

    @Override
    public AjaxJson saveOrUpdate(ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.checkSaveOrUpdate(actProjectSaveVo, ajaxJson);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        String headId = "";
        TtActEntity head = this.packageHead(actProjectSaveVo);
        List<TtActDetailEntity> actDetails = this.packageDetail(actProjectSaveVo);
        List<TtActbudgetEntity> budgets = this.packageBudgetDetail(actProjectSaveVo);
        List<TtActProductEntity> produts = this.packageProductDetail(actProjectSaveVo);
        if (StringUtil.isNotEmpty((CharSequence)head.getId())) {
            headId = head.getId();
            this.updateHead(head);
            this.updateDetail(actDetails, head);
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < actDetails.size(); ++i) {
                BigDecimal amountTemp = actDetails.get(i).getAmount();
                amountTemp = amountTemp == null ? BigDecimal.ZERO : amountTemp;
                amount = amount.add(amountTemp);
            }
            head.setAmount(amount);
            this.ttActDao.updateByPrimaryKeySelective(head);
            this.updateBudgets(budgets, head);
            this.updateproduts(produts, head);
        } else {
            List codes = CodeRuleUtil.getCodeList((String)"act_project_detail", (Integer)actDetails.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < actDetails.size(); ++i) {
                actDetails.get(i).setActDetailCode((String)codes.get(i));
                BigDecimal amountTemp = actDetails.get(i).getAmount();
                amountTemp = amountTemp == null ? BigDecimal.ZERO : amountTemp;
                amount = amount.add(amountTemp);
            }
            head.setAmount(amount);
            this.ttActDao.insertSelective(head);
            headId = head.getId();
            actDetails.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActDetailDao.insertSelective(item);
            });
            budgets.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActbudgetDao.insertSelective(item);
            });
            produts.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActProductDao.insertSelective(item);
            });
        }
        this.saveActProjectTargets(actProjectSaveVo.getTarget(), headId);
        return ajaxJson;
    }

    private void updateproduts(List<TtActProductEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActProductDao.selectByExample(example);
        Map<String, TtActProductEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(BaseEntity::getId, account -> account));
        ArrayList<TtActProductEntity> addList = new ArrayList<TtActProductEntity>();
        ArrayList<TtActProductEntity> updateList = new ArrayList<TtActProductEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActProductEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(item -> this.ttActProductDao.insertSelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActProductDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActProductDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateBudgets(List<TtActbudgetEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActbudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActbudgetDao.selectByExample(example);
        Map<String, TtActbudgetEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(TtActbudgetEntity::getId, account -> account));
        ArrayList<TtActbudgetEntity> addList = new ArrayList<TtActbudgetEntity>();
        ArrayList<TtActbudgetEntity> updateList = new ArrayList<TtActbudgetEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActbudgetEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(item -> this.ttActbudgetDao.insertSelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActbudgetDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActbudgetDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateDetail(List<TtActDetailEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActDetailDao.selectByExample(example);
        Map<String, TtActDetailEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(BaseEntity::getId, account -> account));
        ArrayList<TtActDetailEntity> addList = new ArrayList<TtActDetailEntity>();
        ArrayList<TtActDetailEntity> updateList = new ArrayList<TtActDetailEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActDetailEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            List codes = CodeRuleUtil.getCodeList((String)"act_project_detail", (Integer)addList.size());
            for (int i = 0; i < addList.size(); ++i) {
                ((TtActDetailEntity)addList.get(i)).setActDetailCode((String)codes.get(i));
                this.ttActDetailDao.insertSelective(addList.get(i));
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActDetailDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActDetailDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateHead(TtActEntity head) {
        this.ttActDao.updateByPrimaryKeySelective(head);
    }

    private TtActEntity packageHead(ActProjectSaveVo actProjectSaveVo) {
        TtActEntity entity = actProjectSaveVo.getHead();
        if (StringUtil.isEmpty((String)entity.getActCode())) {
            entity.setActCode(CodeRuleUtil.getKnlCodingRulesString((String)"act_project"));
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        }
        entity.setActType(ConstantEnum.ACTTYPE.project.getVal());
        return entity;
    }

    private List<TtActDetailEntity> packageDetail(ActProjectSaveVo actProjectSaveVo) {
        List categories = actProjectSaveVo.getCategories();
        ArrayList<TtActDetailEntity> detailEntities = new ArrayList<TtActDetailEntity>();
        for (ActDetailSaveVo detailSaveVo : categories) {
            List items = detailSaveVo.getItems();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)items)) {
                items.forEach(item -> {
                    item.setCategoriesCode(detailSaveVo.getCategoriesCode());
                    item.setCategoriesName(detailSaveVo.getCategoriesName());
                    item.setActType(ConstantEnum.ACTTYPE.project.getVal());
                });
            }
            detailEntities.addAll(items);
        }
        return detailEntities;
    }

    private List<TtActbudgetEntity> packageBudgetDetail(ActProjectSaveVo actProjectSaveVo) {
        ArrayList<TtActbudgetEntity> entities = new ArrayList<TtActbudgetEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actProjectSaveVo.getBudgets())) {
            actProjectSaveVo.getBudgets().forEach(item -> {
                if (StringUtil.isEmpty((String)item.getId())) {
                    item.setId(null);
                }
            });
            entities.addAll(actProjectSaveVo.getBudgets());
        }
        return entities;
    }

    private List<TtActProductEntity> packageProductDetail(ActProjectSaveVo actProjectSaveVo) {
        List categories = actProjectSaveVo.getCategories();
        ArrayList<TtActProductEntity> entities = new ArrayList<TtActProductEntity>();
        for (ActDetailSaveVo actDetailSaveVo : categories) {
            List items = actDetailSaveVo.getProducts();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)items)) continue;
            items.forEach(item -> item.setCategoriesCode(actDetailSaveVo.getCategoriesCode()));
            entities.addAll(items);
        }
        return entities;
    }

    @Override
    public AjaxJson deleteHead(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity head = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        if (StringUtils.equals((CharSequence)head.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue()) || StringUtils.equals((CharSequence)head.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue())) {
            ajaxJson.setErrMsg("\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u5220\u9664");
            return ajaxJson;
        }
        this.ttActDao.deleteByPrimaryKey(id);
        Example exampleDetail = new Example(TtActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActDetailDao.deleteByExample(exampleDetail);
        Example exampleProduct = new Example(TtActProductEntity.class);
        Example.Criteria criteriaProduct = exampleProduct.createCriteria();
        criteriaProduct.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActProductDao.deleteByExample(exampleProduct);
        Example exampleBudget = new Example(TtActbudgetEntity.class);
        Example.Criteria criteriaBudget = exampleBudget.createCriteria();
        criteriaBudget.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActbudgetDao.deleteByExample(exampleBudget);
        return ajaxJson;
    }

    @Override
    public String getTargetData(String id, String processKey) {
        return "";
    }

    @Override
    public AjaxJson<ActTargetContentObjVo> getActProjectTargets(String processKey) {
        AjaxJson ajaxJson = this.activitiFeign.getTargetHeadAndDefault(processKey);
        AjaxJson result = new AjaxJson();
        if (ajaxJson.isSuccess()) {
            ActTargetContentObjVo vo = new ActTargetContentObjVo();
            ActTargetContentObjEntity entity = (ActTargetContentObjEntity)ajaxJson.getObj();
            vo.setHead(entity.getHeadTarget());
            vo.setItems(entity.getItemTarget());
            if (this.targetDataProjectExtendService != null) {
                String itemJson = this.targetDataProjectExtendService.getTargetData(processKey);
                vo.setItems(itemJson);
            }
            vo.setProcessKey(processKey);
            result.setObj((Object)vo);
        }
        return result;
    }

    private void saveActProjectTargets(ActTargetContentObjEntity entity, String id) {
        if (entity == null) {
            return;
        }
        this.actCommonService.saveActProjectTargets(id, entity.getProcessKey(), entity.getHeadTarget(), entity.getItemTarget());
    }
}

