/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActDetailListPartReq;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.actcheck.common.SfaConstantEnum;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.auditinfo.TtAuditInfoFeign;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.auditinfo.vo.AuditInfoRespVo;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtActDetailServiceImpl
extends BaseServiceImpl<TtActDetailEntity>
implements TtActDetailService {
    private final String cust_type = "01";
    private final String terminal_type = "02";
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtAuditInfoFeign ttAuditInfoFeign;

    @Override
    public boolean saveDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        Object entities;
        FormTags[] entities2;
        int i = 0;
        ArrayList<TtActDetailEntity> actDetailEntities = new ArrayList<TtActDetailEntity>();
        AuditInfoRespVo respVo = (AuditInfoRespVo)ApiResultUtil.objResult((AjaxJson)this.ttAuditInfoFeign.getAuditInfoRespVoByFineCode(detailVo.getActSubclassCode(), "1"));
        List auditInfoEntitys = respVo.getAuditInfoEntitys();
        String fineStr = "";
        String fineName = "";
        if (CollectionUtil.listNotEmptyNotSizeZero((List)auditInfoEntitys)) {
            fineStr = auditInfoEntitys.stream().map(TtAuditInfoEntity::getCode).collect(Collectors.joining(","));
            fineName = auditInfoEntitys.stream().map(TtAuditInfoEntity::getName).collect(Collectors.joining(","));
            detailVo.setFineStr(fineStr);
            detailVo.setFineName(fineName);
        }
        List<Object> custTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getCustJson()) && (entities2 = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getCustJson(), FormTags[].class)) != null && entities2.length > 0) {
            custTags = Arrays.asList(entities2);
        }
        List<Object> orgTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getOrgJson()) && (entities = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getOrgJson(), FormTags[].class)) != null && ((Object)entities).length > 0) {
            orgTags = Arrays.asList(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(custTags)) {
            for (FormTags formTags : custTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setCustomerCode(formTags.getCode());
                entity.setCustomerName(formTags.getName());
                entity.setAuditStatus("0");
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else if (CollectionUtil.listNotEmptyNotSizeZero(orgTags)) {
            for (FormTags formTags : orgTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setOrgCode(formTags.getCode());
                entity.setOrgName(formTags.getName());
                entity.setAuditStatus("0");
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else {
            TtActDetailEntity entity = new TtActDetailEntity();
            entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
            MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
            entity.setAuditStatus("0");
            actDetailEntities.add(entity);
            i = this.insertList(actDetailEntities);
        }
        return i > 0;
    }

    @Override
    public Integer checkShareProduct(String tempUuid) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        criteria.andEqualTo("needShare", (Object)"1");
        int count = this.ttActDetailDao.selectCountByExample(example);
        return count;
    }

    @Override
    public boolean updateDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        Example.Criteria criteria;
        Example example;
        FormTags[] entities;
        FormTags[] entities2;
        int i = 0;
        ArrayList<TtActDetailEntity> actDetailEntities = new ArrayList<TtActDetailEntity>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)detailVo.getFineStr())) {
            AuditInfoRespVo respVo = (AuditInfoRespVo)ApiResultUtil.objResult((AjaxJson)this.ttAuditInfoFeign.getAuditInfoRespVoByFineCode(detailVo.getActSubclassCode(), "1"));
            List auditInfoEntitys = respVo.getAuditInfoEntitys();
            String fineStr = "";
            String fineName = "";
            if (CollectionUtil.listNotEmptyNotSizeZero((List)auditInfoEntitys)) {
                fineStr = auditInfoEntitys.stream().map(TtAuditInfoEntity::getCode).collect(Collectors.joining(","));
                fineName = auditInfoEntitys.stream().map(TtAuditInfoEntity::getName).collect(Collectors.joining(","));
                detailVo.setFineStr(fineStr);
                detailVo.setFineName(fineName);
            }
        }
        List<Object> custTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getCustJson()) && (entities2 = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getCustJson(), FormTags[].class)) != null && entities2.length > 0) {
            custTags = Arrays.asList(entities2);
        }
        List<Object> orgTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getOrgJson()) && (entities = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getOrgJson(), FormTags[].class)) != null && entities.length > 0) {
            orgTags = Arrays.asList(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(custTags)) {
            example = new Example(TtActDetailEntity.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("id", (Object)detailVo.getId());
            this.ttActDetailDao.deleteByExample(example);
            for (FormTags formTags : custTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.UPDATE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setCustomerCode(formTags.getCode());
                entity.setCustomerName(formTags.getName());
                entity.setAuditStatus("0");
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else if (CollectionUtil.listNotEmptyNotSizeZero(orgTags)) {
            example = new Example(TtActDetailEntity.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("id", (Object)detailVo.getId());
            this.ttActDetailDao.deleteByExample(example);
            for (FormTags formTags : orgTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.UPDATE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setOrgCode(formTags.getCode());
                entity.setOrgName(formTags.getName());
                entity.setAuditStatus("0");
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else {
            TtActDetailEntity entity = new TtActDetailEntity();
            entity.setEnableStatus(ConstantEnum.StatusEnum.UPDATE.getValue());
            MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
            actDetailEntities.add(entity);
            i = this.updateBatchByPrimaryKeySelective(actDetailEntities);
        }
        return i > 0;
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailByActsPage(TtActDetailVo vo, Page page, List<String> actCodes) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.findTtActDetailListByActs(vo, actCodes), (Page)page);
    }

    @Override
    public List<TtActDetailVo> findTtActDetailByQuery(TtActDetailVo vo) {
        return this.ttActDetailDao.findTtActDetailByQuery(vo);
    }

    @Override
    public List<TtActDetailVo> findActDetailByCon(String clientCode, String clientType) {
        List<TtActDetailVo> list = this.ttActDetailDao.findActDetailByCon(clientCode, clientType);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List ttCostTypeFines;
            ArrayList fineCodes = new ArrayList();
            list.forEach(item -> fineCodes.add(item.getActSubclassCode()));
            if (CollectionUtil.listNotEmptyNotSizeZero(fineCodes) && CollectionUtil.listNotEmptyNotSizeZero((List)(ttCostTypeFines = this.ttCostTypeFeign.findFineListByCodes(fineCodes).getObjList()))) {
                HashMap fineMap = new HashMap();
                ttCostTypeFines.forEach(item -> {
                    if (!fineMap.containsKey(item.getFineCode())) {
                        fineMap.put(item.getFineCode(), item.getDiscernModel());
                    }
                });
                list.forEach(item -> {
                    if (fineMap.containsKey(item.getActSubclassCode())) {
                        item.setDiscernModel((String)fineMap.get(item.getActSubclassCode()));
                    }
                });
            }
            list.stream().filter(dd -> StringUtils.isNotBlank((String)dd.getDiscernModel())).forEach(item -> {
                Map map;
                KnlDictDataEntity data = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_project_group.getVal(), (String)item.getDiscernModel());
                if (data != null && (map = data.getExtendMap()) != null && map.size() > 0) {
                    String a = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_a.getVal()));
                    String b = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_b.getVal()));
                    String c = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_c.getVal()));
                    ArrayList<String> modelProjectNameList = new ArrayList<String>();
                    if (StringUtil.isNotEmpty((CharSequence)a)) {
                        KnlDictDataEntity aStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)a);
                        modelProjectNameList.add(aStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)b)) {
                        KnlDictDataEntity bStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)b);
                        modelProjectNameList.add(bStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)c)) {
                        KnlDictDataEntity cStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)c);
                        modelProjectNameList.add(cStr.getDictValue());
                    }
                    item.setModelProjectName(((Object)modelProjectNameList).toString().replace("[", "").replace("]", ""));
                }
            });
        }
        return list;
    }

    @Override
    public List<TtActDetailEntity> findDetailByCodes(List<String> codes) {
        List<Object> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(codes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public List<TtActDetailEntity> findDetailByActCodes(List<String> actCodes) {
        List<Object> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(actCodes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actCode", actCodes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public TtActDetailEntity getEntity(String id, String actDetailCode) {
        if (StringUtil.isBlank((CharSequence)id) && StringUtil.isBlank((CharSequence)actDetailCode)) {
            return null;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TtActDetailEntity)this.ttActDetailDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotEmpty((CharSequence)actDetailCode)) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actDetailCode", (Object)actDetailCode);
            List detailEntities = this.ttActDetailDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)detailEntities)) {
                return (TtActDetailEntity)detailEntities.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public AjaxJson checkActDetail(String actDetailCode, BigDecimal auditAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TtActDetailEntity entity = this.getEntity(null, actDetailCode);
        TtCostTypeFineEntity costTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, entity.getActSubclassCode()).getObj();
        String isMultipleAudit = costTypeFineEntity.getIsMultipleAudit();
        if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)isMultipleAudit) && StringUtil.equals((String)entity.getAuditStatus(), (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
            throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + "\u53ea\u80fd\u6838\u9500\u4e00\u6b21");
        }
        ArrayList<String> rules = new ArrayList<String>();
        rules.add(ConstantEnum.FIELD_NAME.above_audit.name());
        Map map = this.ttCostTypeFeign.findCostTypeCons(actDetailCode, rules).getMapT();
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amount = entity.getAuditAmount() == null ? BigDecimal.ZERO : entity.getAuditAmount();
        amount = amount.add(auditAmount);
        if (map.isEmpty() || !map.containsKey(ConstantEnum.FIELD_NAME.above_audit.name())) {
            maxAmount = entity.getAmount();
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        } else {
            BigDecimal extraAuditRatio = costTypeFineEntity.getExtraAuditRatio();
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            maxAmount = entity.getAmount().multiply(extraAuditRatio).divide(new BigDecimal(100)).add(entity.getAmount());
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        }
        attributes.put("costTypeFineEntity", costTypeFineEntity);
        attributes.put("maxAmount", maxAmount);
        ajaxJson.setAttributes(attributes);
        return ajaxJson;
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailListPage(TtActDetailVo vo, Page page) {
        List<TtActDetailVo> list = this.ttActDetailDao.findTtActDetailListPage(vo);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> list, (Page)page);
        return pageInfo;
    }

    @Override
    public void deleteDetailByActCode(String actCode) {
        this.ttActDetailDao.deleteDetailByActCode(actCode);
    }

    @Override
    public void deleteDetailByDetaiCodes(List<String> actDetailCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(actDetailCodes)) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("actDetailCode", actDetailCodes);
            this.deleteByExample(example);
        }
    }

    @Override
    public List<TtActDetailVo> findTtActDetailListForEstimate(TtActDetailVo vo) {
        return this.ttActDetailDao.findTtActDetailListForEstimate(vo);
    }

    @Override
    public PageInfo<TtActDetailEntity> listPart(ActDetailListPartReq actDetailListPartReq) {
        Page page = new Page();
        page.setPage(actDetailListPartReq.getPageNum().toString());
        page.setRows(actDetailListPartReq.getPageSize().toString());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.listPart(actDetailListPartReq.getActDetailCode()), (Page)page);
        return pageInfo;
    }
}

