/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.quota.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActFineEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.quota.service.TtActQuotaActivitiTargetTextExtend;
import com.biz.eisp.act.quota.service.TtActQuotaActivitiVariablesExtend;
import com.biz.eisp.act.quota.service.TtActQuotaTargetRefreshExtend;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActFineService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.auditinfo.TtAuditInfoFeign;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.auditinfo.vo.AuditInfoRespVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ttActQuotaController"})
public class TtActQuotaController {
    private static final Logger log = LoggerFactory.getLogger(TtActQuotaController.class);
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired(required=false)
    private TtActQuotaActivitiVariablesExtend ttActQuotaActivitiVariablesExtend;
    @Autowired(required=false)
    private TtActQuotaActivitiTargetTextExtend ttActQuotaActivitiTargetTextExtend;
    @Autowired(required=false)
    private TtActQuotaTargetRefreshExtend ttActQuotaTargetRefreshExtend;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired
    private TtActFineService ttActFineService;
    @Autowired
    private TtAuditInfoFeign ttAuditInfoFeign;

    @RequestMapping(value={"findTtActQuotaPage"})
    @ResponseBody
    public DataGrid findTtActQuotaPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.quota.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info.getList() != null && info.getList().size() > 0) {
            for (TtActVo ttActVo : info.getList()) {
                BigDecimal fsalesAmountCustomer = new BigDecimal(0);
                BigDecimal fsalesAmountTerminal = new BigDecimal(0);
                BigDecimal amount = new BigDecimal(0);
                TtActDetailVo detailVo = new TtActDetailVo();
                detailVo.setTempUuid(ttActVo.getTempUuid());
                List<TtActDetailVo> ttActDetailVos = this.ttActDetailService.findTtActDetailByQuery(detailVo);
                if (ttActDetailVos != null && ttActDetailVos.size() > 0) {
                    for (TtActDetailVo ttActDetailVo : ttActDetailVos) {
                        if (StringUtil.isNotEmpty((Object)ttActDetailVo.getFsalesAmountCustomer())) {
                            fsalesAmountCustomer = fsalesAmountCustomer.add(ttActDetailVo.getFsalesAmountCustomer());
                        }
                        if (StringUtil.isNotEmpty((Object)ttActDetailVo.getFsalesAmountTerminal())) {
                            fsalesAmountTerminal = fsalesAmountTerminal.add(ttActDetailVo.getFsalesAmountTerminal());
                        }
                        amount = amount.add(ttActDetailVo.getAmount());
                    }
                }
                ttActVo.setAmount(amount);
                ttActVo.setFsalesAmountCustomer(fsalesAmountCustomer);
                ttActVo.setFsalesAmountTerminal(fsalesAmountTerminal);
            }
        }
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtActVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                j.setSuccess(this.ttActService.update(vo));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.quota.getVal());
                j.setSuccess(this.ttActService.save(vo));
            }
        }
        catch (BusinessException e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody TtActVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActTargetVo actTargetVo = new ActTargetVo();
        if (vo.getTarget() == null || !StringUtil.isNotBlank((CharSequence)vo.getTarget().getHeadTarget())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        String head = vo.getTarget().getHeadTarget();
        List targetConfigEntities = JsonPropertyUtil.toArray((String)head, ActTargetConfigEntity.class);
        actTargetVo.setHead(targetConfigEntities);
        if (this.ttActQuotaTargetRefreshExtend != null) {
            actTargetVo.setItems((List)this.ttActQuotaTargetRefreshExtend.activitiTargetRefresh(vo));
        } else if (vo.getTarget() != null && StringUtil.isNotBlank((CharSequence)vo.getTarget().getHeadTarget())) {
            head = vo.getTarget().getHeadTarget();
            JSONArray jsonArray = new JSONArray();
            List targetConfigEntities2 = JsonPropertyUtil.toArray((String)head, ActTargetConfigEntity.class);
            targetConfigEntities2 = targetConfigEntities2 == null ? new ArrayList() : targetConfigEntities2;
            JSONObject object = new JSONObject();
            targetConfigEntities2.forEach(item -> {
                String key = item.getFiled();
                String value = item.getDefaultValue();
                String string = value = value == null ? "" : value;
                if (StringUtil.isNotBlank((CharSequence)key)) {
                    object.put(key, (Object)value);
                }
            });
            jsonArray.add((Object)object);
            actTargetVo.setItems((List)jsonArray);
        }
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        vo.setBusinessUrl("/page/ttActQuotaController/goUpdateOrAdd?clickFunctionId=402880826c40ca9b016c45d853950004&load=detail");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmActActivitiFeign");
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        Map<Object, Object> variablesSelf = new HashMap();
        if (this.ttActQuotaActivitiVariablesExtend != null) {
            variablesSelf = this.ttActQuotaActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo);
        }
        if (variablesSelf != null) {
            variables.putAll(variablesSelf);
        }
        String json = null;
        if (this.ttActQuotaActivitiTargetTextExtend != null) {
            json = this.ttActQuotaActivitiTargetTextExtend.createActivitiTargetText(entity, vo);
        } else {
            ArrayList<TtActEntity> list = new ArrayList<TtActEntity>();
            list.add(entity);
            json = JSONArray.toJSONString(list);
        }
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setFuncid("402880826c40ca9b016c45d853950004");
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.QUOTA.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        try {
            ajaxJson = this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
            if (!ajaxJson.isSuccess()) {
                this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
                return ajaxJson;
            }
        }
        catch (Exception e) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg(e.getMessage());
            return ajaxJson;
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ajaxJson.setErrMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        if (!ajaxJson.isSuccess()) {
            this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue(), entity.getId());
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(entity.getId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.quota.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.quota.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActProductService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActQuotaDetailPage"})
    @ResponseBody
    public DataGrid findTtActQuotaDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = this.ttActService.findTtActDetailPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findProductList"})
    @ResponseBody
    public DataGrid findProductList(HttpServletRequest request, TtActProductEntity productEntity) {
        EuPage page = new EuPage(request);
        page.setRows("1000");
        List products = new ArrayList();
        if (StringUtil.isNotBlank((CharSequence)productEntity.getActCode())) {
            products = this.ttActProductService.select(productEntity);
        }
        return new DataGrid(products, (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                j = this.ttActService.delete(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"saveOrUpdateActFine"})
    public AjaxJson<TtActFineEntity> saveOrUpdateActFine(TtActFineEntity actfine) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)actfine.getAuditMaterial())) {
            String[] arr = actfine.getAuditMaterial().split(",");
            ArrayList<String> haset = new ArrayList<String>();
            for (int i = 0; i < arr.length; ++i) {
                haset.add(DictUtil.getDictDataVal((String)"audit_material", (String)arr[i]));
            }
            TtActDetailEntity detailEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(actfine.getId());
            detailEntity.setFineStr(actfine.getAuditMaterial());
            detailEntity.setFineName(String.join((CharSequence)",", haset));
            detailEntity.setFineUpdateDate(DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setFineUpdateBy(UserUtils.getUser().getRealname());
            this.ttActDetailService.updateByPrimaryKey(detailEntity);
            actfine.setAuditMaterialName(detailEntity.getFineStr());
        }
        ajaxJson.setObj((Object)actfine);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateActFineForRebate"})
    public AjaxJson<TtActDetailEntity> saveOrUpdateActFineForRebate(TtActFineEntity actfine) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActDetailEntity detailEntity = new TtActDetailEntity();
        if (StringUtils.isNotBlank((CharSequence)actfine.getAuditMaterial())) {
            String[] arr = actfine.getAuditMaterial().split(",");
            ArrayList<String> haset = new ArrayList<String>();
            for (int i = 0; i < arr.length; ++i) {
                haset.add(DictUtil.getDictDataVal((String)"audit_material", (String)arr[i]));
            }
            detailEntity.setFineStr(actfine.getAuditMaterial());
            detailEntity.setFineName(String.join((CharSequence)",", haset));
            detailEntity.setFineUpdateDate(DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setFineUpdateBy(UserUtils.getUser().getRealname());
            actfine.setAuditMaterialName(detailEntity.getFineStr());
        }
        ajaxJson.setObj((Object)detailEntity);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"findActFineList"})
    AjaxJson<TtActFineEntity> findActFineList(String actCode, String actSubCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtActFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actCode);
        criteria.andEqualTo("actSubclassCode", (Object)actSubCode);
        List list = this.ttActFineService.selectExample(example);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"getFineStr"})
    public AjaxJson<TtActDetailVo> getFineStr(String actSubclassCode) {
        AjaxJson j = new AjaxJson();
        TtActDetailVo detailVo = new TtActDetailVo();
        AuditInfoRespVo respVo = (AuditInfoRespVo)ApiResultUtil.objResult((AjaxJson)this.ttAuditInfoFeign.getAuditInfoRespVoByFineCode(actSubclassCode, "1"));
        List auditInfoEntitys = respVo.getAuditInfoEntitys();
        String fineStr = "";
        String fineName = "";
        if (CollectionUtil.listNotEmptyNotSizeZero((List)auditInfoEntitys)) {
            fineStr = auditInfoEntitys.stream().map(TtAuditInfoEntity::getCode).collect(Collectors.joining(","));
            fineName = auditInfoEntitys.stream().map(TtAuditInfoEntity::getName).collect(Collectors.joining(","));
            detailVo.setFineStr(fineStr);
            detailVo.setFineName(fineName);
        }
        j.setObj((Object)detailVo);
        return j;
    }
}

