/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.api.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActDetailGiftEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActFineEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.service.DingtalkActBusDataExtend;
import com.biz.eisp.act.service.TtActDetailGiftService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActFineService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActListReq;
import com.biz.eisp.act.vo.DingtalkActBusDataResp;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.configure.vo.FormTableVo;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.kernel.KnlDictDataFeign;
import com.biz.eisp.kernel.KnlFormConfigFeign;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.TtAuditActFeign;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(value="\u6d3b\u52a8\u63a5\u53e3", tags={"\u6d3b\u52a8\u63a5\u53e3"})
@RequestMapping(value={"ttApiActController"})
@RestController
public class TtApiActController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtAuditActFeign ttAuditActFeign;
    @Autowired
    private TtActFineService ttActFineService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private TtActDetailGiftService ttActDetailGiftService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private KnlFormConfigFeign knlFormConfigFeign;
    @Autowired
    private KnlDictDataFeign knlDictDataFeign;
    @Autowired(required=false)
    private DingtalkActBusDataExtend dingtalkActBusDataExtend;

    @GetMapping(value={"selectByPrimaryKey"})
    public AjaxJson<TtActEntity> selectByPrimaryKey(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u9489\u9489\u5ba1\u6279\u4e1a\u52a1\u6570\u636e")
    @GetMapping(value={"loadActForDingtalkBusData"})
    public AjaxJson<DingtalkActBusDataResp> loadActForDingtalkBusData(@RequestParam(value="businessObjId") String businessObjId, @RequestParam(value="funid") String funid, @RequestParam(value="bizType") String bizType) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(businessObjId);
        if (null == entity) {
            throw new BusinessException("\u672a\u52a0\u8f7d\u5230\u6d3b\u52a8\u6570\u636e\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        DingtalkActBusDataResp resp = new DingtalkActBusDataResp();
        String tempUuid = entity.getTempUuid();
        resp.setTempUuid(tempUuid);
        resp.setAct(entity);
        this.loadShare(resp);
        resp.setActDetails(this.ttActDetailService.findEnableByActCodes(Lists.newArrayList((Object[])new String[]{entity.getActCode()})));
        this.loadGifts(resp);
        this.loadBudets(resp);
        this.convertData(funid, bizType, resp);
        if (null != this.dingtalkActBusDataExtend) {
            resp = this.dingtalkActBusDataExtend.doExtend(resp, businessObjId, funid, bizType);
        }
        ajaxJson.setObj((Object)resp);
        return ajaxJson;
    }

    private void convertData(String funid, String bizType, DingtalkActBusDataResp resp) {
        if (StringUtil.isBlank((CharSequence)funid) || StringUtil.isBlank((CharSequence)bizType)) {
            return;
        }
        FormTableVo config = (FormTableVo)this.knlFormConfigFeign.getEnableConfigByFuncid(funid, bizType).getObj();
        Set<String> dictTypeKeys = this.takeDictTypeKeys(config);
        if (dictTypeKeys.size() > 0) {
            Map dict = (Map)this.knlDictDataFeign.loadDictTypeKVByCodes(dictTypeKeys.stream().collect(Collectors.joining(","))).getObj();
            this.convertDict(dict, config, resp);
        }
    }

    private Set<String> takeDictTypeKeys(FormTableVo config) {
        HashSet dictTypeKeys = Sets.newHashSet();
        if (null == config) {
            return dictTypeKeys;
        }
        List formConfig = config.getFormConfig();
        List tableConfig = config.getTableConfig();
        if (!CollectionUtil.listEmpty((List)formConfig)) {
            formConfig.stream().forEach(v -> {
                if (StringUtil.isNotBlank((CharSequence)v.getDictionary())) {
                    dictTypeKeys.add(v.getDictionary());
                }
            });
        }
        if (!CollectionUtil.listEmpty((List)tableConfig)) {
            tableConfig.stream().forEach(v -> {
                if (StringUtil.isNotBlank((CharSequence)v.getDictionary())) {
                    dictTypeKeys.add(v.getDictionary());
                }
            });
        }
        return dictTypeKeys;
    }

    private void convertDict(Map<String, Map<String, String>> dict, FormTableVo config, DingtalkActBusDataResp resp) {
        List formConfig = config.getFormConfig();
        List tableConfig = config.getTableConfig();
        if (!CollectionUtils.isEmpty(dict)) {
            if (!CollectionUtil.listEmpty((List)formConfig)) {
                this.convertDictAct(dict, formConfig, resp);
            }
            if (!CollectionUtil.listEmpty((List)tableConfig)) {
                tableConfig.stream().forEach(v -> this.convertDictActDetail(dict, tableConfig, resp));
            }
        }
    }

    private void convertDictActDetail(Map<String, Map<String, String>> dict, List<KnlTableConfigVo> formConfig, DingtalkActBusDataResp resp) {
        List actDetails = resp.getActDetails();
        formConfig.stream().forEach(v -> {
            Map dictData;
            if (StringUtil.isNotBlank((CharSequence)v.getDictionary()) && StringUtil.isNotBlank((CharSequence)v.getField()) && !CollectionUtils.isEmpty((Map)(dictData = (Map)dict.get(v.getDictionary()))) && !CollectionUtils.isEmpty((Collection)actDetails)) {
                actDetails.stream().forEach(actDetail -> BeanCopyUtils.setProperty((Object)actDetail, (String)v.getField(), dictData.get(BeanCopyUtils.getProperty((Object)actDetail, (String)v.getField()))));
            }
        });
    }

    private void convertDictAct(Map<String, Map<String, String>> dict, List<KnlFormConfigVo> formConfig, DingtalkActBusDataResp resp) {
        TtActEntity act = resp.getAct();
        formConfig.stream().forEach(v -> {
            Map dictData;
            if (StringUtil.isNotBlank((CharSequence)v.getDictionary()) && StringUtil.isNotBlank((CharSequence)v.getFieldCode()) && !CollectionUtils.isEmpty((Map)(dictData = (Map)dict.get(v.getDictionary())))) {
                BeanCopyUtils.setProperty((Object)act, (String)v.getFieldCode(), dictData.get(BeanCopyUtils.getProperty((Object)act, (String)v.getFieldCode())));
            }
        });
    }

    private void loadGifts(DingtalkActBusDataResp resp) {
        List actDetails = resp.getActDetails();
        if (CollectionUtil.listEmpty((List)actDetails)) {
            return;
        }
        Set codes = actDetails.stream().map(TtActDetailEntity::getActDetailCode).filter(v -> StringUtil.isNotBlank((CharSequence)v)).collect(Collectors.toSet());
        Example example = new Example(TtActDetailGiftEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        Map map = this.ttActDetailGiftService.selectExample(example).stream().collect(Collectors.groupingBy(TtActDetailGiftEntity::getActDetailCode, Collectors.toList()));
        resp.setActDetailGiftMap(map);
    }

    private void loadBudets(DingtalkActBusDataResp resp) {
        Example example = new Example(TtActbudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)resp.getAct().getActCode());
        resp.setActbudgets(this.ttActbudgetService.selectExample(example));
    }

    private void loadShare(DingtalkActBusDataResp resp) {
        int need = this.ttActDetailService.checkShareProduct(resp.getTempUuid());
        if (need > 0) {
            resp.setNeedShare(Integer.valueOf(1));
            TtActProductEntity productEntity = new TtActProductEntity();
            productEntity.setActCode(resp.getAct().getActCode());
            List products = this.ttActProductService.select(productEntity);
            resp.setProductShare(products);
        } else {
            resp.setProductShare((List)Lists.newArrayList());
        }
    }

    @GetMapping(value={"getTtActVoByActCode"})
    public AjaxJson<TtActEntity> getTtActVoByActCode(@RequestParam(value="actCode") String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = this.ttActService.getTtActVoByActCode(actCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getActEntitys"})
    public AjaxJson<TtActEntity> getActEntitys(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entitys = this.ttActService.getActEntitys(codes);
        ajaxJson.setObjList(entitys);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtActDetailPage"})
    public List<TtActDetailVo> findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = null;
        ArrayList<TtActDetailVo> ttActDetailVos = new ArrayList<TtActDetailVo>();
        List actEntities = ApiResultUtil.listResult((AjaxJson)this.ttAuditActFeign.getActCodeByTempId(vo.getTempUuid()), (boolean)true);
        List<String> actCodes = new ArrayList<String>();
        actCodes.add("_");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
            actCodes = actEntities.stream().map(TtAuditActEntity::getActCode).collect(Collectors.toList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(info = this.ttActDetailService.findTtActDetailByActsPage(vo, (Page)page, actCodes)).getList())) {
            info.getList().forEach(item -> {
                TtCostTypeFineEntity ttCostTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, item.getActSubclassCode()).getObj();
                if (ttCostTypeFineEntity != null && StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getActMethodCode()) && (StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.DDFY.getValue()) || StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.HFFY.getValue()))) {
                    String isMultipleAudit = StringUtil.isEmpty((String)ttCostTypeFineEntity.getIsMultipleAudit()) ? "0" : ttCostTypeFineEntity.getIsMultipleAudit();
                    item.setIsMultipleAudit(isMultipleAudit);
                    ttActDetailVos.add((TtActDetailVo)item);
                }
            });
        }
        return ttActDetailVos;
    }

    @RequestMapping(value={"findTtActAdvanceList"})
    public DataGrid findTtActAdvanceList(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> ttActVos = this.ttActService.findTtActListForAdvance(vo, (Page)page);
        return new DataGrid(ttActVos);
    }

    @GetMapping(value={"getActEntitysByDetailCode"})
    public AjaxJson<TtActEntity> getActEntitysByDetailCode(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActEntity> entities = this.ttActService.getActEntitysByDetailCode(codes);
        ajaxJson.setList(entities);
        return ajaxJson;
    }

    @PostMapping(value={"saveOrUpdateActFine"})
    AjaxJson<TtActFineEntity> saveOrUpdateActFine(@RequestBody TtActFineEntity actfine) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActDetailEntity detailEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(actfine.getId());
        detailEntity.setFineStr(actfine.getAuditMaterial());
        actfine.setId(null);
        this.ttActFineService.insertSelective(actfine);
        ajaxJson.setObj((Object)actfine);
        return ajaxJson;
    }

    @GetMapping(value={"findActFineList"})
    AjaxJson<TtActFineEntity> findActFineList(@RequestParam(value="actCode") String actCode, @RequestParam(value="actSubCode") String actSubCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtActFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actCode);
        criteria.andEqualTo("actSubclassCode", (Object)actSubCode);
        List list = this.ttActFineService.selectExample(example);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u7533\u8bf7\u672a\u6838\u9500\u660e\u7ec6\uff08\u5206\u9875\uff09")
    @RequestMapping(value={"list"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public PageInfo<TtActDetailEntity> list(@RequestBody ActListReq actListReq) {
        return this.ttActService.list(actListReq);
    }
}

