/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.ActEndService;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.pay.audit.TtAuditActDetailFeign;
import com.biz.eisp.pay.audit.TtAuditActFeign;
import com.biz.eisp.pay.audit.TtAuditFeign;
import com.biz.eisp.tools.CodeRuleUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class ActEndServiceImpl
implements ActEndService {
    @Autowired
    private TtActDao ttActDao;
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtAuditActFeign ttAuditActFeign;
    @Autowired
    private TtAuditActDetailFeign ttAuditActDetailFeign;
    @Autowired
    private TtAuditFeign ttAuditFeign;

    @Override
    public void actEnd(String id) {
        this.doQuotaAct(id);
    }

    private void doQuotaAct(String id) {
        TtActEntity entity = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        if (entity == null) {
            return;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)entity.getActCode());
        List entities = this.ttActDetailDao.selectByExample(example);
        ArrayList<TtActDetailEntity> toDoDetailList = new ArrayList<TtActDetailEntity>();
        for (TtActDetailEntity actDetailEntity : entities) {
            TtCostTypeFineEntity costTypeFineEntity;
            String actSubclassCode = actDetailEntity.getActSubclassCode();
            if (StringUtil.isEmpty((String)actSubclassCode) || (costTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, actSubclassCode).getObj()) == null || !StringUtil.equals((String)costTypeFineEntity.getIsAudit(), (String)ConstantEnum.YesNoEnum.ZERO.getValue()) || StringUtil.equals((String)costTypeFineEntity.getActMethodCode(), (String)ConstantEnum.ActMethodEnum.SDFY.getValue())) continue;
            toDoDetailList.add(actDetailEntity);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(toDoDetailList)) {
            this.saveAtuit(toDoDetailList, entity);
        }
    }

    private void saveAtuit(List<TtActDetailEntity> detailEntitys, TtActEntity entity) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(detailEntitys)) {
            return;
        }
        TtAuditEntity ttAuditEntity = this.createTtAuditEntity(entity);
        TtAuditActEntity actEntity = this.createTtAuditActEntity(ttAuditEntity, entity);
        ArrayList<TtAuditActDetailEntity> auditActDetailEntities = new ArrayList<TtAuditActDetailEntity>();
        for (TtActDetailEntity detailEntity : detailEntitys) {
            TtAuditActDetailEntity ttAuditActDetailEntity = this.createDetail(detailEntity, entity, ttAuditEntity);
            auditActDetailEntities.add(ttAuditActDetailEntity);
        }
        ApiResultUtil.objResult((AjaxJson)this.ttAuditFeign.insertSelective(ttAuditEntity), (boolean)true);
        ApiResultUtil.objResult((AjaxJson)this.ttAuditActFeign.insertSelective(actEntity), (boolean)true);
        ApiResultUtil.objResult((AjaxJson)this.ttAuditActDetailFeign.insertList(auditActDetailEntities), (boolean)true);
    }

    private TtAuditEntity createTtAuditEntity(TtActEntity entity) {
        TtAuditEntity ttAuditEntity = new TtAuditEntity();
        ttAuditEntity.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        ttAuditEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        ttAuditEntity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
        ttAuditEntity.setAuditName(entity.getActName() + "(\u81ea\u52a8\u6838\u9500)");
        ttAuditEntity.setTempUuid("tempuuid" + UUIDGenerator.generate());
        ttAuditEntity.setCreateBy(entity.getCreateBy());
        ttAuditEntity.setCreateName(entity.getCreateName());
        return ttAuditEntity;
    }

    private TtAuditActEntity createTtAuditActEntity(TtAuditEntity ttAuditEntity, TtActEntity entity) {
        TtAuditActEntity actEntity = new TtAuditActEntity();
        actEntity.setAuditCode(ttAuditEntity.getAuditCode());
        actEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        actEntity.setActCode(entity.getActCode());
        actEntity.setActName(entity.getActName());
        actEntity.setTempUuid(ttAuditEntity.getTempUuid());
        return actEntity;
    }

    private TtAuditActDetailEntity createDetail(TtActDetailEntity detailEntity, TtActEntity entity, TtAuditEntity ttAuditEntity) {
        TtAuditActDetailEntity ttAuditActDetailEntity = new TtAuditActDetailEntity();
        ttAuditActDetailEntity.setCustomerCode(detailEntity.getCustomerCode());
        ttAuditActDetailEntity.setCustomerName(detailEntity.getCustomerName());
        ttAuditActDetailEntity.setFeeUsed(BigDecimal.ZERO);
        ttAuditActDetailEntity.setAuditCode(ttAuditEntity.getAuditCode());
        ttAuditActDetailEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        ttAuditActDetailEntity.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
        ttAuditActDetailEntity.setActDetailCode(detailEntity.getActDetailCode());
        ttAuditActDetailEntity.setActCode(entity.getActCode());
        ttAuditActDetailEntity.setActSubclassCode(detailEntity.getActSubclassCode());
        ttAuditActDetailEntity.setActSubclassName(detailEntity.getActSubclassName());
        ttAuditActDetailEntity.setTerminalCode(detailEntity.getTerminalCode());
        ttAuditActDetailEntity.setTerminalName(detailEntity.getTerminalName());
        ttAuditActDetailEntity.setPayType(detailEntity.getPayType());
        ttAuditActDetailEntity.setAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setAuditAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setCurrentAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setTempUuid(ttAuditEntity.getTempUuid());
        ttAuditActDetailEntity.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
        ttAuditActDetailEntity.setActType(entity.getActType());
        ttAuditActDetailEntity.setCategoriesCode(detailEntity.getCategoriesCode());
        ttAuditActDetailEntity.setCategoriesName(detailEntity.getCategoriesName());
        ttAuditActDetailEntity.setActName(entity.getActName());
        return ttAuditActDetailEntity;
    }
}

