/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.price.controller;

import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.price.service.ActPriceDetailExtend;
import com.biz.eisp.act.price.service.TtActPriceActivitiBeforeCommitExtend;
import com.biz.eisp.act.price.service.TtActPriceActivitiTargetTextExtend;
import com.biz.eisp.act.price.service.TtActPriceActivitiVariablesExtend;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.service.TtPriceActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActPriceSaveDataVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.price.PriceParamVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttActPriceController"})
public class TtActPriceController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtPriceActService ttPriceActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired(required=false)
    private TtActPriceActivitiVariablesExtend ttActPriceActivitiVariablesExtend;
    @Autowired(required=false)
    private TtActPriceActivitiTargetTextExtend ttActPriceActivitiTargetTextExtend;
    @Autowired(required=false)
    private ActPriceDetailExtend actPriceDetailExtend;
    @Autowired(required=false)
    private TtActPriceActivitiBeforeCommitExtend ttActPriceActivitiBeforeCommitExtend;

    @RequestMapping(value={"findTtActPricePage"})
    public DataGrid findTtActPricePage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getProductList"})
    @ResponseBody
    public AjaxJson<TtActProductEntity> getProductList(String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(actCode);
        List<TtActProductEntity> productEntities = this.ttActProductService.getProductsBycodes(codes);
        ajaxJson.setList(productEntities);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody TtActPriceSaveDataVo vo) {
        AjaxJson j = new AjaxJson();
        j = StringUtils.isNotEmpty((CharSequence)vo.getId()) ? this.ttPriceActService.updateEntity(vo) : this.ttPriceActService.saveEntity(vo);
        return j;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody TtActPriceSaveDataVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActTargetVo actTargetVo = this.ttPriceActService.getTarget(vo);
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActPriceDetailPage"})
    @ResponseBody
    public DataGrid findTtActPriceDetailPage(HttpServletRequest request, TtActDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailEntity> info = this.ttPriceActService.getActDetailPage(entity, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getProductPrice"})
    @ResponseBody
    public AjaxJson getProductPrice(HttpServletRequest request, PriceParamVo priceParamVo) {
        priceParamVo.setPriceType("type1");
        AjaxJson ajaxJson = this.mdmApiFeign.getPriceCommon(priceParamVo);
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        Map<String, Object> variablesTemp;
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isBlank((CharSequence)vo.getFuncid())) {
            ajaxJson.setErrMsg("FunctionId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        vo.setBusinessUrl("/page/ttActPriceController/goUpdateOrAdd?clickFunctionId=402880826c4baa41016c4bd0747f0000&load=detail");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("callback_service", "tpmActPriceActivitiFeign");
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        if (this.ttActPriceActivitiVariablesExtend != null && (variablesTemp = this.ttActPriceActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo)) != null) {
            variables.putAll(variablesTemp);
        }
        String json = null;
        json = this.ttActPriceActivitiTargetTextExtend != null ? this.ttActPriceActivitiTargetTextExtend.createActivitiTargetText(entity, vo) : this.ttActService.getTargetDataForPrice(vo.getBusinessObjId());
        try {
            ajaxJson = this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), vo.getBusinessObjId());
            if (!ajaxJson.isSuccess()) {
                this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
                return ajaxJson;
            }
        }
        catch (BusinessException e1) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg(e1.getMessage());
            return ajaxJson;
        }
        catch (Exception e) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
            return ajaxJson;
        }
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.PRICE.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        if (null != this.ttActPriceActivitiBeforeCommitExtend) {
            this.ttActPriceActivitiBeforeCommitExtend.beforeCommit(activitiBusinessVo);
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            ajaxJson.setErrMsg(e.getMessage());
            e.printStackTrace();
        }
        if (!ajaxJson.isSuccess()) {
            this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue(), entity.getId());
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(vo.getBusinessObjId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                j = this.ttActService.delete(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(value={"findExcelDetail"})
    public AjaxJson<TtActDetailEntity> findExcelDetail(String tempId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<Object> list = new ArrayList();
        if (this.actPriceDetailExtend != null) {
            list = this.actPriceDetailExtend.findExcelDetail(tempId);
        }
        ajaxJson.setList(list);
        return ajaxJson;
    }
}

