/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActDetailGiftEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.service.DingtalkActBusDataExtend;
import com.biz.eisp.act.service.DingtalkActBusDataService;
import com.biz.eisp.act.service.DingtalkProjectActBusDataExtend;
import com.biz.eisp.act.service.TtActDetailGiftService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.DingtalkActBusDataResp;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.configure.vo.FormTableVo;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.kernel.KnlDictDataFeign;
import com.biz.eisp.kernel.KnlFormConfigFeign;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class DingtalkActBusDataServiceImpl
implements DingtalkActBusDataService {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired(required=false)
    private DingtalkActBusDataExtend dingtalkActBusDataExtend;
    @Autowired(required=false)
    private DingtalkProjectActBusDataExtend dingtalkProjectActBusDataExtend;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private TtActDetailGiftService ttActDetailGiftService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private KnlFormConfigFeign knlFormConfigFeign;
    @Autowired
    private KnlDictDataFeign knlDictDataFeign;

    @Override
    public DingtalkActBusDataResp loadProjectActForDingtalkBusData(String businessObjId, String funid, String bizType) {
        if (null != this.dingtalkProjectActBusDataExtend) {
            DingtalkActBusDataResp resp = this.dingtalkProjectActBusDataExtend.projectActExtend(businessObjId, funid, bizType);
            if (StringUtil.isBlank((CharSequence)resp.getProjectBusDataUrl())) {
                resp.setProjectBusDataUrl("/template/projectActivity");
            }
            return resp;
        }
        DingtalkActBusDataResp resp = new DingtalkActBusDataResp();
        resp.setProjectBusDataUrl("/template/projectActivity");
        return resp;
    }

    @Override
    public DingtalkActBusDataResp loadActForDingtalkBusData(String businessObjId, String funid, String bizType) {
        DingtalkActBusDataResp resp;
        if (TaBaseBusinessObjExtend.BizType.PROJECT.getCode().equals(bizType)) {
            resp = this.loadProjectActForDingtalkBusData(businessObjId, funid, bizType);
        } else {
            resp = this.doLoadActForDingtalkBusData(businessObjId, funid, bizType);
            resp.setProjectBusDataUrl(null);
        }
        return resp;
    }

    private DingtalkActBusDataResp doLoadActForDingtalkBusData(String businessObjId, String funid, String bizType) {
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(businessObjId);
        if (null == entity) {
            throw new BusinessException("\u672a\u52a0\u8f7d\u5230\u6d3b\u52a8\u6570\u636e\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        DingtalkActBusDataResp resp = new DingtalkActBusDataResp();
        String tempUuid = entity.getTempUuid();
        resp.setTempUuid(tempUuid);
        resp.setAct(entity);
        this.loadShare(resp);
        resp.setActDetails(this.ttActDetailService.findEnableByActCodes(Lists.newArrayList((Object[])new String[]{entity.getActCode()})));
        this.loadGifts(resp);
        this.loadBudets(resp);
        this.convertData(funid, bizType, resp);
        if (null != this.dingtalkActBusDataExtend) {
            resp = this.dingtalkActBusDataExtend.actExtend(resp, businessObjId, funid, bizType);
        }
        return resp;
    }

    private void loadShare(DingtalkActBusDataResp resp) {
        int need = this.ttActDetailService.checkShareProduct(resp.getTempUuid());
        if (need > 0) {
            resp.setNeedShare(Integer.valueOf(1));
            TtActProductEntity productEntity = new TtActProductEntity();
            productEntity.setActCode(resp.getAct().getActCode());
            List products = this.ttActProductService.select(productEntity);
            resp.setProductShare(products);
        } else {
            resp.setProductShare((List)Lists.newArrayList());
        }
    }

    private void loadGifts(DingtalkActBusDataResp resp) {
        List actDetails = resp.getActDetails();
        if (CollectionUtil.listEmpty((List)actDetails)) {
            return;
        }
        Set codes = actDetails.stream().map(TtActDetailEntity::getActDetailCode).filter(v -> StringUtil.isNotBlank((CharSequence)v)).collect(Collectors.toSet());
        Example example = new Example(TtActDetailGiftEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        Map map = this.ttActDetailGiftService.selectExample(example).stream().collect(Collectors.groupingBy(TtActDetailGiftEntity::getActDetailCode, Collectors.toList()));
        resp.setActDetailGiftMap(map);
    }

    private void loadBudets(DingtalkActBusDataResp resp) {
        Example example = new Example(TtActbudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)resp.getAct().getActCode());
        resp.setActbudgets(this.ttActbudgetService.selectExample(example));
    }

    private void convertData(String funid, String bizType, DingtalkActBusDataResp resp) {
        if (StringUtil.isBlank((CharSequence)funid) || StringUtil.isBlank((CharSequence)bizType)) {
            return;
        }
        FormTableVo config = (FormTableVo)this.knlFormConfigFeign.getEnableConfigByFuncid(funid, bizType).getObj();
        Set<String> dictTypeKeys = this.takeDictTypeKeys(config);
        if (dictTypeKeys.size() > 0) {
            Map dict = (Map)this.knlDictDataFeign.loadDictTypeKVByCodes(dictTypeKeys.stream().collect(Collectors.joining(","))).getObj();
            this.convertDict(dict, config, resp);
        }
    }

    private Set<String> takeDictTypeKeys(FormTableVo config) {
        HashSet dictTypeKeys = Sets.newHashSet();
        if (null == config) {
            return dictTypeKeys;
        }
        List formConfig = config.getFormConfig();
        List tableConfig = config.getTableConfig();
        if (!CollectionUtil.listEmpty((List)formConfig)) {
            formConfig.stream().forEach(v -> {
                if (StringUtil.isNotBlank((CharSequence)v.getDictionary())) {
                    dictTypeKeys.add(v.getDictionary());
                }
            });
        }
        if (!CollectionUtil.listEmpty((List)tableConfig)) {
            tableConfig.stream().forEach(v -> {
                if (StringUtil.isNotBlank((CharSequence)v.getDictionary())) {
                    dictTypeKeys.add(v.getDictionary());
                }
            });
        }
        return dictTypeKeys;
    }

    private void convertDict(Map<String, Map<String, String>> dict, FormTableVo config, DingtalkActBusDataResp resp) {
        List formConfig = config.getFormConfig();
        List tableConfig = config.getTableConfig();
        if (!CollectionUtils.isEmpty(dict)) {
            if (!CollectionUtil.listEmpty((List)formConfig)) {
                this.convertDictAct(dict, formConfig, resp);
            }
            if (!CollectionUtil.listEmpty((List)tableConfig)) {
                tableConfig.stream().forEach(v -> this.convertDictActDetail(dict, tableConfig, resp));
            }
        }
    }

    private void convertDictActDetail(Map<String, Map<String, String>> dict, List<KnlTableConfigVo> formConfig, DingtalkActBusDataResp resp) {
        List actDetails = resp.getActDetails();
        formConfig.stream().forEach(v -> {
            Map dictData;
            if (StringUtil.isNotBlank((CharSequence)v.getDictionary()) && StringUtil.isNotBlank((CharSequence)v.getField()) && !CollectionUtils.isEmpty((Map)(dictData = (Map)dict.get(v.getDictionary()))) && !CollectionUtils.isEmpty((Collection)actDetails)) {
                actDetails.stream().forEach(actDetail -> BeanCopyUtils.setProperty((Object)actDetail, (String)v.getField(), dictData.get(BeanCopyUtils.getProperty((Object)actDetail, (String)v.getField()))));
            }
        });
    }

    private void convertDictAct(Map<String, Map<String, String>> dict, List<KnlFormConfigVo> formConfig, DingtalkActBusDataResp resp) {
        TtActEntity act = resp.getAct();
        formConfig.stream().forEach(v -> {
            Map dictData;
            if (StringUtil.isNotBlank((CharSequence)v.getDictionary()) && StringUtil.isNotBlank((CharSequence)v.getFieldCode()) && !CollectionUtils.isEmpty((Map)(dictData = (Map)dict.get(v.getDictionary())))) {
                BeanCopyUtils.setProperty((Object)act, (String)v.getFieldCode(), dictData.get(BeanCopyUtils.getProperty((Object)act, (String)v.getFieldCode())));
            }
        });
    }
}

