/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.project.controller;

import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.project.service.ActProjectActivitiBeforeCommitExtend;
import com.biz.eisp.act.project.service.ActProjectActivitiTargetTextExtend;
import com.biz.eisp.act.project.service.ActProjectService;
import com.biz.eisp.act.project.service.TtActProjectActivitiVariablesExtend;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.TaProcessFeign;
import com.biz.eisp.activiti.TaProcessOrgPageFeign;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.activiti.vo.ActTargetContentObjVo;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.project.vo.ActProjectSaveVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actProjectController"})
public class ActProjectController {
    private static final Logger log = LoggerFactory.getLogger(ActProjectController.class);
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private TaProcessFeign taProcessFeign;
    @Autowired
    private ActProjectService actProjectService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired
    private TmOrgFeign tmOrgFeign;
    @Autowired
    private TaProcessOrgPageFeign taProcessOrgPageFeign;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired(required=false)
    private TtActProjectActivitiVariablesExtend ttActProjectActivitiVariablesExtend;
    @Autowired(required=false)
    private ActProjectActivitiTargetTextExtend actProjectActivitiTargetTextExtend;
    @Autowired(required=false)
    private ActProjectActivitiBeforeCommitExtend actProjectActivitiBeforeCommitExtend;

    @RequestMapping(value={"findActProjectListPage"})
    @ResponseBody
    public DataGrid findActProjectListPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.project.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findActBudgetListPage"})
    @ResponseBody
    public AjaxJson<TtActbudgetEntity> findActBudgetListPage(HttpServletRequest request, TtActVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page = new EuPage(request);
        PageInfo<TtActbudgetEntity> info = this.ttActbudgetService.findActBudgetListPage(vo, (Page)page);
        ajaxJson.setList(info.getList());
        return ajaxJson;
    }

    @RequestMapping(value={"getActProjectSaveVoByCode"})
    @ResponseBody
    public AjaxJson<ActProjectSaveVo> getActProjectSaveVoByCode(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        ActProjectSaveVo actProjectSaveVo = this.actProjectService.getActProjectSaveVoByCode(null, id);
        ajaxJson.setObj((Object)actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.actProjectService.saveOrUpdate(actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActTargetVo actTargetVo = this.actProjectService.getTarget(actProjectSaveVo);
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteHead"})
    @ResponseBody
    public AjaxJson deleteHead(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.actProjectService.deleteHead(id);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        Map<String, Object> variablesTemp;
        AjaxJson ajaxJson = new AjaxJson();
        vo.setBusinessUrl("/page/actProjectController/goSaveUpdate?clickFunctionId=402880826e3bd6af016e3bdd1c160000&load=detail");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("callback_service", "tpmProjectActivitiFeign");
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        if (this.ttActProjectActivitiVariablesExtend != null && (variablesTemp = this.ttActProjectActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo)) != null) {
            variables.putAll(variablesTemp);
        }
        String json = null;
        json = this.actProjectActivitiTargetTextExtend != null ? this.actProjectActivitiTargetTextExtend.createActivitiTargetText(entity, vo) : this.actProjectService.getTargetData(vo.getBusinessObjId(), vo.getProcessKey());
        try {
            ajaxJson = this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), vo.getBusinessObjId());
            if (!ajaxJson.isSuccess()) {
                this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
                return ajaxJson;
            }
        }
        catch (BusinessException e1) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg(e1.getMessage());
            return ajaxJson;
        }
        catch (Exception e) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
            return ajaxJson;
        }
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.PROJECT.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        if (null != this.actProjectActivitiBeforeCommitExtend) {
            this.actProjectActivitiBeforeCommitExtend.beforeCommit(activitiBusinessVo);
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ajaxJson.setErrMsg("\u63d0\u4ea4\u5931\u8d25");
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        if (!ajaxJson.isSuccess()) {
            this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue(), entity.getId());
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(vo.getBusinessObjId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }

    @RequestMapping(value={"getActProjectTargets"})
    @ResponseBody
    public AjaxJson<ActTargetContentObjVo> getActProjectTargets(String processKey) {
        AjaxJson<ActTargetContentObjVo> ajaxJson = this.actProjectService.getActProjectTargets(processKey);
        return ajaxJson;
    }

    @RequestMapping(value={"getBpmKeys"})
    @ResponseBody
    public AjaxJson<TaProcessEntity> saveActProjectTargets(String processPage) {
        UserRedis userRedis = UserUtils.getUser();
        AjaxJson json = new AjaxJson();
        List orgVos = this.tmOrgFeign.getOrgListByUser(userRedis.getId(), null).getObjList();
        if (CollectionUtil.listEmpty((List)orgVos) || StringUtil.isBlank((CharSequence)processPage)) {
            json.setSuccess(false);
            json.setMsg("processPage \u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List orgTypes = orgVos.stream().map(TmOrgVo::getOrgType).collect(Collectors.toList());
            List orgCodes = orgVos.stream().map(TmOrgVo::getOrgCode).collect(Collectors.toList());
            List bpmKeys = this.taProcessOrgPageFeign.getBpmKeyByOrg(processPage, orgTypes, orgCodes).getObjList();
            List taProcessEntities = this.taProcessFeign.getTaProcessEntityByProcessKey(bpmKeys).getObjList();
            json.setObjList(taProcessEntities);
        }
        return json;
    }
}

