/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.departcost.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.departcost.service.TtActDepartCostActivitiBeforeCommitExtend;
import com.biz.eisp.act.departcost.service.TtActDepartCostActivitiTargetTextExtend;
import com.biz.eisp.act.departcost.service.TtActDepartCostActivitiVariablesExtend;
import com.biz.eisp.act.departcost.service.TtActDepartCostTargetRefreshExtend;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.fee.TtBudgetDetailFeign;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"ttActDepartCostController"})
@RestController
public class TtActDepartCostController {
    private static final Logger log = LoggerFactory.getLogger(TtActDepartCostController.class);
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired(required=false)
    private TtActDepartCostActivitiTargetTextExtend ttActDepartCostActivitiTargetTextExtend;
    @Autowired(required=false)
    private TtActDepartCostActivitiVariablesExtend ttActDepartCostActivitiVariablesExtend;
    @Autowired(required=false)
    private TtActDepartCostTargetRefreshExtend ttActDepartCostTargetRefreshExtend;
    @Autowired(required=false)
    private TtActDepartCostActivitiBeforeCommitExtend ttActDepartActivitiBeforeCommitExtend;
    @Autowired
    private TtBudgetDetailFeign ttBudgetDetailFeign;
    @Autowired
    private ActCommonService actCommonService;

    @RequestMapping(value={"findTtActDepartCostPage"})
    @ResponseBody
    public DataGrid findTtActDepartCostPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.departcost.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtActVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            j.setSuccess(this.ttActService.update(vo));
        } else {
            vo.setActType(ConstantEnum.ACTTYPE.departcost.getVal());
            j.setSuccess(this.ttActService.save(vo));
        }
        return j;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody TtActVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        vo.setActType(ConstantEnum.ACTTYPE.departcost.getVal());
        ActTargetVo actTargetVo = this.ttActService.getTarget(vo);
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.departcost.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.departcost.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActProductService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActDepartCostDetailPage"})
    @ResponseBody
    public DataGrid findTtActDepartCostDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = this.ttActService.findTtActDetailPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        Map<String, Object> variablesTemp;
        AjaxJson ajaxJson = new AjaxJson();
        vo.setBusinessUrl("/page/ttActDepartCostController/goUpdateOrAdd?clickFunctionId=402880826c5fdcb5016c60d05ed20000&load=detail");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("callback_service", "tpmDepartCostActivitiFeign");
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        if (this.ttActDepartCostActivitiVariablesExtend != null && (variablesTemp = this.ttActDepartCostActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo)) != null) {
            variables.putAll(variablesTemp);
        }
        String json = null;
        if (this.ttActDepartCostActivitiTargetTextExtend != null) {
            json = this.ttActDepartCostActivitiTargetTextExtend.createActivitiTargetText(entity, vo);
        } else {
            ArrayList<TtActEntity> list = new ArrayList<TtActEntity>();
            list.add(entity);
            json = JSONArray.toJSONString(list);
        }
        try {
            ajaxJson = this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), vo.getBusinessObjId());
            if (!ajaxJson.isSuccess()) {
                this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
                return ajaxJson;
            }
        }
        catch (BusinessException e1) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg(e1.getMessage());
            return ajaxJson;
        }
        catch (Exception e) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
            return ajaxJson;
        }
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.DEPART_COST.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        if (null != this.ttActDepartActivitiBeforeCommitExtend) {
            this.ttActDepartActivitiBeforeCommitExtend.beforeCommit(activitiBusinessVo);
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ajaxJson.setErrMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        if (!ajaxJson.isSuccess()) {
            this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue(), entity.getId());
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(entity.getId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtActAdvance(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                j = this.ttActService.delete(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }
}

