/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.rebate.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.rebate.service.ActRebateDetailExtend;
import com.biz.eisp.act.rebate.service.TtActRebateActivitiBeforeCommitExtend;
import com.biz.eisp.act.rebate.service.TtActRebateActivitiTargetTextExtend;
import com.biz.eisp.act.rebate.service.TtActRebateActivitiVariablesExtend;
import com.biz.eisp.act.rebate.service.TtRebateActService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActPriceSaveDataVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttActRebateController"})
public class TtActRebateController {
    private static final Logger log = LoggerFactory.getLogger(TtActRebateController.class);
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired(required=false)
    private TtActRebateActivitiVariablesExtend ttActRebateActivitiVariablesExtend;
    @Autowired(required=false)
    private TtActRebateActivitiTargetTextExtend ttActRebateActivitiTargetTextExtend;
    @Autowired(required=false)
    private TtActRebateActivitiBeforeCommitExtend ttActRebateActivitiBeforeCommitExtend;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired
    private TtRebateActService ttRebateActService;
    @Autowired(required=false)
    private ActRebateDetailExtend actRebateDetailExtend;

    @RequestMapping(value={"findTtActRebatePage"})
    @ResponseBody
    public DataGrid findTtActRebatePage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.rebate.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody TtActPriceSaveDataVo vo) {
        AjaxJson j = new AjaxJson();
        j = StringUtils.isNotEmpty((CharSequence)vo.getId()) ? this.ttRebateActService.updateEntity(vo) : this.ttRebateActService.saveEntity(vo);
        return j;
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public AjaxJson<ActTargetVo> refresh(@RequestBody TtActPriceSaveDataVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        vo.getHead().setActType(ConstantEnum.ACTTYPE.rebate.getVal());
        ActTargetVo actTargetVo = this.ttRebateActService.getTarget(vo);
        ajaxJson.setObj((Object)actTargetVo);
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        vo.setBusinessUrl("/page/ttActRebateController/goUpdateOrAdd?clickFunctionId=402880e8700403d00170040be9470000&load=detail");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmActRebateFeign");
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        Map<Object, Object> variablesSelf = new HashMap();
        if (this.ttActRebateActivitiVariablesExtend != null) {
            variablesSelf = this.ttActRebateActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo);
        }
        if (variablesSelf != null) {
            variables.putAll(variablesSelf);
        }
        String json = null;
        if (this.ttActRebateActivitiTargetTextExtend != null) {
            json = this.ttActRebateActivitiTargetTextExtend.createActivitiTargetText(entity, vo);
        } else {
            ArrayList<TtActEntity> list = new ArrayList<TtActEntity>();
            list.add(entity);
            json = JSONArray.toJSONString(list);
        }
        try {
            ajaxJson = this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), vo.getBusinessObjId());
            if (!ajaxJson.isSuccess()) {
                this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
                return ajaxJson;
            }
        }
        catch (Exception e) {
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            ajaxJson.setErrMsg(e.getMessage());
            return ajaxJson;
        }
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.REBATE.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        if (null != this.ttActRebateActivitiBeforeCommitExtend) {
            this.ttActRebateActivitiBeforeCommitExtend.beforeCommit(activitiBusinessVo);
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ajaxJson.setErrMsg("\u63d0\u4ea4\u5931\u8d25");
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
        }
        if (!ajaxJson.isSuccess()) {
            this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue(), entity.getId());
            this.actCommonService.rollBackFeeBudgutDetail(entity.getActCode());
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(entity.getId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.rebate.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.rebate.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActProductService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setErrMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActRebateDetailPage"})
    @ResponseBody
    public DataGrid findTtActRebateDetailPage(HttpServletRequest request, TtActDetailEntity entity) {
        EuPage page = new EuPage(request);
        page.setRows("1000");
        PageInfo<TtActDetailEntity> info = this.ttRebateActService.getActDetailPage(entity, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                j = this.ttActService.delete(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(value={"findExcelDetail"})
    public AjaxJson<TtActDetailEntity> findExcelDetail(String tempId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<Object> list = new ArrayList();
        if (this.actRebateDetailExtend != null) {
            list = this.actRebateDetailExtend.findExcelDetail(tempId);
        }
        ajaxJson.setList(list);
        return ajaxJson;
    }
}

