/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.attachement.service.impl;

import com.biz.eisp.act.attachement.service.TtActAttachmentService;
import com.biz.eisp.act.dao.TtActAttachmentDao;
import com.biz.eisp.attachment.entity.TtActAttachmentEntity;
import com.biz.eisp.attachment.vo.TtActAttachBusVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.upload.KnlDownAttachmentFeign;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtActAttachmentServiceImpl
extends BaseServiceImpl<TtActAttachmentEntity>
implements TtActAttachmentService {
    @Autowired
    private TtActAttachmentDao ttActAttachmentDao;
    @Autowired
    private KnlDownAttachmentFeign downAttachmentFeign;

    @Override
    public AjaxJson saveUploadFile(TtActAttachBusVo vo) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        json.setMsg("\u4e0a\u4f20\u6210\u529f");
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)vo.getList())) {
            return json;
        }
        List list = vo.getList();
        int num = 0;
        try {
            TtActAttachmentEntity param = new TtActAttachmentEntity();
            param.setBusinessKey(vo.getBusinessKey());
            List old = this.ttActAttachmentDao.select(param);
            old.forEach(e -> this.ttActAttachmentDao.delete(e));
            list.forEach(e -> {
                e.setBusinessKey(vo.getBusinessKey());
                e.setAttachmentType(vo.getAttachmentType());
                e.setStatus(ConstantEnum.StatusEnum.NEW.getValue());
            });
            num = this.ttActAttachmentDao.batchInsertList(list);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            json.setSuccess(false);
            json.setMsg("\u4fdd\u5b58\u5f02\u5e38");
        }
        return json;
    }

    @Override
    public AjaxJson removeUploadFile(String id) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        json.setMsg("\u5220\u9664\u6210\u529f");
        TtActAttachmentEntity entity = (TtActAttachmentEntity)this.ttActAttachmentDao.selectByPrimaryKey(id);
        if (StringUtil.isEmpty((Object)entity)) {
            return json;
        }
        int num = 0;
        try {
            num = this.ttActAttachmentDao.delete(entity);
            this.downAttachmentFeign.removeDownAttach(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg("\u64cd\u4f5c\u5f02\u5e38");
        }
        if (num != 1) {
            json.setSuccess(false);
            json.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return json;
    }

    @Override
    public PageInfo<TtActAttachmentEntity> findAttachmentList(String businessKey, Page page) {
        Example example = new Example(TtActAttachmentEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessKey", (Object)businessKey);
        criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
        return PageAutoHelperUtil.generatePage(() -> this.ttActAttachmentDao.selectByExample(example), (Page)page);
    }
}

