/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.plans.controller;

import com.biz.eisp.act.plans.entity.TtSalesPlansEntity;
import com.biz.eisp.act.plans.service.TtSalesPlansService;
import com.biz.eisp.act.plans.vo.TtSalesPlansVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttSalesPlansController"})
public class TtSalesPlansController {
    @Autowired
    private TtSalesPlansService ttSalesPlansService;

    @GetMapping(value={"getTtSalesPlansEntity"})
    public AjaxJson<TtSalesPlansEntity> getTtSalesPlansEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtSalesPlansEntity entity = this.ttSalesPlansService.getTtSalesPlansEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtSalesPlansPage"})
    public DataGrid findTtSalesPlansPage(HttpServletRequest request, TtSalesPlansVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtSalesPlansVo> ttSalesPlansVoPageInfo = this.ttSalesPlansService.findTtSalesPlansPage(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(TtSalesPlansVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.ttSalesPlansService.update(vo);
            } else {
                this.ttSalesPlansService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"deleteTtSalesPlans"})
    public AjaxJson deleteTtSalesPlans(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttSalesPlansService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

