/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.common.ActCommonService;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActDetailGiftEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.price.service.ActPriceActivitiTargetRefreshExtend;
import com.biz.eisp.act.project.service.TtActbudgetService;
import com.biz.eisp.act.service.ActPriceSaveOrUpdateExtend;
import com.biz.eisp.act.service.TtActDetailGiftService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.service.TtPriceActService;
import com.biz.eisp.act.vo.TtActPriceSaveDataVo;
import com.biz.eisp.activiti.ActTargetConfigFeign;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtPriceActServiceImpl
extends BaseServiceImpl<TtActEntity>
implements TtPriceActService {
    private static final Logger log = LoggerFactory.getLogger(TtPriceActServiceImpl.class);
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActDetailGiftService ttActDetailGiftService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private ActCommonService actCommonService;
    @Autowired(required=false)
    private ActPriceSaveOrUpdateExtend actPriceSaveOrUpdateExtend;
    @Autowired(required=false)
    private ActPriceActivitiTargetRefreshExtend actPriceActivitiTargetRefreshExtend;
    @Autowired
    private ActTargetConfigFeign actTargetConfigFeign;

    @Override
    public PageInfo<TtActDetailEntity> getActDetailPage(TtActDetailEntity entity, Page page) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)entity.getActCode());
        return PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.selectByExample(example), (Page)page);
    }

    @Override
    public AjaxJson saveOrUpdate(TtActPriceSaveDataVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.createActHead(vo);
        this.createActDetail(vo);
        this.createActProduct(vo);
        this.createActBudget(vo);
        this.createActDetailGift(vo);
        if (this.actPriceSaveOrUpdateExtend != null && !(ajaxJson = this.actPriceSaveOrUpdateExtend.saveOrUpdateCheck(vo)).isSuccess()) {
            return ajaxJson;
        }
        this.saveOrUpdateActDetail(vo);
        this.saveOrUpdateActProduct(vo);
        this.saveOrUpdateActBudget(vo);
        this.saveOrUpdateActHead(vo);
        try {
            String workFlowKey = vo.getHead().getWorkFlowKey();
            if (StringUtil.isNotBlank((CharSequence)workFlowKey)) {
                ActTargetVo actTargetVo = this.getTarget(vo);
                Gson gson = new Gson();
                String headTarget = gson.toJson((Object)actTargetVo.getHead());
                String itemTarget = gson.toJson((Object)actTargetVo.getItems());
                this.actCommonService.saveActProjectTargets(vo.getId(), workFlowKey, headTarget, itemTarget);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtPriceActServiceImpl.class)
    public AjaxJson saveEntity(TtActPriceSaveDataVo vo) {
        return this.saveOrUpdate(vo);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtPriceActServiceImpl.class)
    public AjaxJson updateEntity(TtActPriceSaveDataVo vo) {
        return this.saveOrUpdate(vo);
    }

    private void saveOrUpdateActHead(TtActPriceSaveDataVo vo) {
        TtActEntity head = vo.getHead();
        if (StringUtil.isNotBlank((CharSequence)head.getId())) {
            UserRedis userRedis = UserUtils.getUser();
            head.setUpdateName(userRedis.getRealname());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm");
            head.setUpdateDate(sdf.format(new Date()));
            this.ttActService.updateByPrimaryKeySelective(head);
        } else {
            this.ttActService.insertSelective(head);
        }
        vo.setId(head.getId());
    }

    private void saveOrUpdateActBudget(TtActPriceSaveDataVo vo) {
        List products = vo.getBudgets();
        ArrayList<String> actCodes = new ArrayList<String>();
        actCodes.add(vo.getHead().getActCode());
        List<TtActbudgetEntity> oldEntitys = this.ttActbudgetService.getActbudgetsByCodes(actCodes);
        Map<String, TtActbudgetEntity> mapOld = oldEntitys.stream().collect(Collectors.toMap(TtActbudgetEntity::getId, item -> item));
        ArrayList addList = new ArrayList();
        ArrayList updateList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        products.forEach(item -> {
            if (mapOld.containsKey(item.getId())) {
                updateList.add(item);
                mapOld.remove(item.getId());
            } else {
                addList.add(item);
            }
        });
        if (!mapOld.isEmpty()) {
            mapOld.forEach((k, v) -> deleteList.add(v));
        }
        addList.forEach(item -> this.ttActbudgetService.insertSelective(item));
        updateList.forEach(item -> this.ttActbudgetService.updateByPrimaryKeySelective(item));
        deleteList.forEach(item -> this.ttActbudgetService.deleteByPrimaryKey(item.getId()));
    }

    private void saveOrUpdateActProduct(TtActPriceSaveDataVo vo) {
        List products = vo.getProducts();
        ArrayList<String> actCodes = new ArrayList<String>();
        actCodes.add(vo.getHead().getActCode());
        List<TtActProductEntity> productsOld = this.ttActProductService.getProductsBycodes(actCodes);
        Map<String, TtActProductEntity> mapOld = productsOld.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        ArrayList addList = new ArrayList();
        ArrayList updateList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        products.forEach(item -> {
            if (mapOld.containsKey(item.getId())) {
                updateList.add(item);
                mapOld.remove(item.getId());
            } else {
                addList.add(item);
            }
        });
        if (!mapOld.isEmpty()) {
            mapOld.forEach((k, v) -> deleteList.add(v));
        }
        addList.forEach(item -> this.ttActProductService.insertSelective(item));
        updateList.forEach(item -> this.ttActProductService.updateByPrimaryKeySelective(item));
        deleteList.forEach(item -> this.ttActProductService.deleteByPrimaryKey(item.getId()));
    }

    private void saveOrUpdateActDetail(TtActPriceSaveDataVo vo) {
        List<String> detailCodes;
        TtActEntity head = vo.getHead();
        if (head.getAmount() == null) {
            head.setAmount(BigDecimal.ZERO);
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(head.getActCode());
        ArrayList actDetailEntities = this.ttActDetailService.findDetailByActCodes(codes);
        actDetailEntities = actDetailEntities == null ? new ArrayList() : actDetailEntities;
        Map<String, TtActDetailEntity> mapOld = actDetailEntities.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        ArrayList addList = new ArrayList();
        ArrayList updateList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        List detailNew = vo.getDetails();
        detailNew.forEach(item -> {
            String id = item.getId();
            if (mapOld.containsKey(id)) {
                updateList.add(item);
                mapOld.remove(id);
            } else {
                addList.add(item);
            }
            head.setAmount(head.getAmount().add(item.getAmount()));
        });
        if (mapOld != null && !mapOld.isEmpty()) {
            mapOld.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            detailCodes = deleteList.stream().map(TtActDetailEntity::getActDetailCode).collect(Collectors.toList());
            this.ttActDetailGiftService.deleteEntityByDetaoCodes(detailCodes);
            this.ttActDetailService.deleteDetailByDetaiCodes(detailCodes);
        }
        addList.forEach(item -> {
            this.ttActDetailService.insertSelective(item);
            List gifts = item.getGifts();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)gifts)) {
                gifts.forEach(temp -> this.ttActDetailGiftService.insertSelective(temp));
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            detailCodes = updateList.stream().map(TtActDetailEntity::getActDetailCode).collect(Collectors.toList());
            updateList.forEach(item -> this.ttActDetailService.updateByPrimaryKeySelective(item));
            ArrayList giftsOlds = this.ttActDetailGiftService.getActDetailGiftsByCodes(detailCodes);
            ArrayList detailGiftNew = new ArrayList();
            updateList.forEach(item -> {
                if (CollectionUtil.listNotEmptyNotSizeZero((List)item.getGifts())) {
                    detailGiftNew.addAll(item.getGifts());
                }
            });
            giftsOlds = giftsOlds == null ? new ArrayList() : giftsOlds;
            Map<String, TtActDetailGiftEntity> mapGiftOld = giftsOlds.stream().collect(Collectors.toMap(TtActDetailGiftEntity::getId, item -> item));
            ArrayList addGifts = new ArrayList();
            ArrayList updateGifts = new ArrayList();
            ArrayList deleteGifts = new ArrayList();
            detailGiftNew.forEach(item -> {
                if (mapGiftOld.containsKey(item.getId())) {
                    updateGifts.add(item);
                    mapGiftOld.remove(item.getId());
                } else {
                    addGifts.add(item);
                }
            });
            if (!mapGiftOld.isEmpty()) {
                mapGiftOld.forEach((k, v) -> deleteGifts.add(v));
            }
            addGifts.forEach(item -> this.ttActDetailGiftService.insertSelective(item));
            updateGifts.forEach(item -> this.ttActDetailGiftService.updateByPrimaryKeySelective(item));
            deleteGifts.forEach(item -> this.ttActDetailGiftService.deleteByPrimaryKey(item));
        }
    }

    private void createActDetailGift(TtActPriceSaveDataVo vo) {
        List details = vo.getDetails();
        details = details == null ? new ArrayList() : details;
        details.forEach(item -> {
            List entities;
            if (StringUtil.isNotBlank((CharSequence)item.getGiftJson()) && CollectionUtil.listNotEmptyNotSizeZero((List)(entities = JsonPropertyUtil.toArray((String)item.getGiftJson(), TtActDetailGiftEntity.class)))) {
                entities.forEach(temp -> temp.setActDetailCode(item.getActDetailCode()));
                item.setGifts(entities);
            }
        });
    }

    private void createActBudget(TtActPriceSaveDataVo vo) {
        TtActEntity head = vo.getHead();
        List details = vo.getBudgets();
        details = details == null ? new ArrayList() : details;
        details.forEach(item -> item.setActCode(head.getActCode()));
    }

    private void createActProduct(TtActPriceSaveDataVo vo) {
        TtActEntity head = vo.getHead();
        List productEntities = vo.getProducts();
        productEntities = productEntities == null ? new ArrayList() : productEntities;
        productEntities.forEach(item -> item.setActCode(head.getActCode()));
    }

    private void createActDetail(TtActPriceSaveDataVo vo) {
        Integer n;
        TtActEntity head = vo.getHead();
        List details = vo.getDetails();
        details = details == null ? new ArrayList() : details;
        Integer cout = 0;
        for (TtActDetailEntity item : details) {
            item.setActCode(head.getActCode());
            item.setActType(ConstantEnum.ACTTYPE.price.getVal());
            item.setTempUuid(head.getTempUuid());
            if (!StringUtil.isBlank((CharSequence)item.getActDetailCode())) continue;
            Integer n2 = cout;
            n = cout = Integer.valueOf(cout + 1);
        }
        if (cout > 0) {
            List codes = CodeRuleUtil.getCodeList((String)ConstantEnum.BUSINESSKEY.act_quota_detail.name(), (Integer)cout);
            cout = 0;
            for (int i = 0; i < details.size(); ++i) {
                TtActDetailEntity item = (TtActDetailEntity)details.get(i);
                if (!StringUtil.isBlank((CharSequence)item.getActDetailCode())) continue;
                item.setActDetailCode((String)codes.get(cout));
                item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                n = cout;
                Integer n3 = cout = Integer.valueOf(cout + 1);
            }
        }
    }

    private void createActHead(TtActPriceSaveDataVo vo) {
        TtActEntity head = vo.getHead();
        if (StringUtil.isNotBlank((CharSequence)head.getId())) {
            TtActEntity headOld = (TtActEntity)this.ttActService.selectByPrimaryKey(head.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)head, (Object)headOld);
            }
            catch (Exception e) {
                throw new BusinessException("\u5bf9\u8c61\u53c2\u6570\u9519\u8bef");
            }
            headOld.setRemarks(head.getRemarks());
            vo.setHead(headOld);
        } else {
            head.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            head.setActCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota.name()));
            head.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            if (StringUtil.isEmpty((String)head.getTempUuid())) {
                head.setTempUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            head.setActType(ConstantEnum.ACTTYPE.price.getVal());
        }
    }

    @Override
    public ActTargetVo getTarget(TtActPriceSaveDataVo vo) {
        ActTargetVo actTargetVo = new ActTargetVo();
        TtActEntity head = vo.getHead();
        if (head == null) {
            return actTargetVo;
        }
        String bpmKey = head.getWorkFlowKey();
        if (StringUtil.isEmpty((String)bpmKey)) {
            return actTargetVo;
        }
        List headList = ApiResultUtil.listResult((AjaxJson)this.actTargetConfigFeign.getTargetConfigByBpmkey(bpmKey));
        actTargetVo.setHead(headList);
        if (this.actPriceActivitiTargetRefreshExtend != null) {
            actTargetVo.setItems((List)this.actPriceActivitiTargetRefreshExtend.activitiTargetRefresh(vo));
        } else {
            actTargetVo.setItems((List)this.ttActService.activitiTargetRefresh(headList));
        }
        return actTargetVo;
    }
}

