/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.vo.ActDetailListPartReq;
import com.biz.eisp.act.vo.TtActDetailGroupVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.actcheck.common.SfaConstantEnum;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.auditinfo.TtAuditInfoFeign;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.auditinfo.vo.AuditInfoRespVo;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtActDetailServiceImpl
extends BaseServiceImpl<TtActDetailEntity>
implements TtActDetailService {
    private static final Logger log = LoggerFactory.getLogger(TtActDetailServiceImpl.class);
    private final String cust_type = "01";
    private final String terminal_type = "02";
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtAuditInfoFeign ttAuditInfoFeign;

    @Override
    public boolean saveDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        Object entities;
        FormTags[] entities2;
        this.resovleCategories(detailVo);
        int i = 0;
        ArrayList<TtActDetailEntity> actDetailEntities = new ArrayList<TtActDetailEntity>();
        AuditInfoRespVo respVo = (AuditInfoRespVo)ApiResultUtil.objResult((AjaxJson)this.ttAuditInfoFeign.getAuditInfoRespVoByFineCode(detailVo.getActSubclassCode(), "1"));
        List auditInfoEntitys = respVo.getAuditInfoEntitys();
        String fineStr = "";
        String fineName = "";
        if (CollectionUtil.listNotEmptyNotSizeZero((List)auditInfoEntitys)) {
            fineStr = auditInfoEntitys.stream().map(TtAuditInfoEntity::getCode).collect(Collectors.joining(","));
            fineName = auditInfoEntitys.stream().map(TtAuditInfoEntity::getName).collect(Collectors.joining(","));
            detailVo.setFineStr(fineStr);
            detailVo.setFineName(fineName);
        }
        List<Object> custTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getCustJson()) && (entities2 = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getCustJson(), FormTags[].class)) != null && entities2.length > 0) {
            custTags = Arrays.asList(entities2);
        }
        List<Object> orgTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getOrgJson()) && (entities = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getOrgJson(), FormTags[].class)) != null && ((Object)entities).length > 0) {
            orgTags = Arrays.asList(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(custTags)) {
            for (FormTags formTags : custTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setCustomerCode(formTags.getCode());
                entity.setCustomerName(formTags.getName());
                entity.setAuditStatus("0");
                entity.setGroupAmount(entity.getAmount());
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else if (CollectionUtil.listNotEmptyNotSizeZero(orgTags)) {
            for (FormTags formTags : orgTags) {
                TtActDetailEntity entity = new TtActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setOrgCode(formTags.getCode());
                entity.setOrgName(formTags.getName());
                entity.setAuditStatus("0");
                entity.setGroupAmount(entity.getAmount());
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
        } else {
            TtActDetailEntity entity = new TtActDetailEntity();
            entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
            MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
            entity.setAuditStatus("0");
            entity.setGroupAmount(entity.getAmount());
            actDetailEntities.add(entity);
            i = this.insertList(actDetailEntities);
        }
        return i > 0;
    }

    private void resovleCategories(TtActDetailVo detailVo) {
        if (null == detailVo || StringUtil.isBlank((CharSequence)detailVo.getCategoriesCode())) {
            return;
        }
        if (StringUtil.isNotBlank((CharSequence)detailVo.getCategoriesName())) {
            return;
        }
        TtCostTypeCategoriesEntity entity = (TtCostTypeCategoriesEntity)this.ttCostTypeFeign.getCategoriesEntity(null, detailVo.getCategoriesCode()).getObj();
        if (null == entity) {
            return;
        }
        detailVo.setCategoriesName(entity.getCategoriesName());
    }

    @Override
    public Integer checkShareProduct(String tempUuid) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        criteria.andEqualTo("needShare", (Object)"1");
        int count = this.ttActDetailDao.selectCountByExample(example);
        return count;
    }

    @Override
    public boolean updateDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        Example.Criteria criteria;
        Example example;
        Object entities;
        FormTags[] entities2;
        int i = 0;
        ArrayList<TtActDetailEntity> actDetailEntities = new ArrayList<TtActDetailEntity>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)detailVo.getFineStr())) {
            AuditInfoRespVo respVo = (AuditInfoRespVo)ApiResultUtil.objResult((AjaxJson)this.ttAuditInfoFeign.getAuditInfoRespVoByFineCode(detailVo.getActSubclassCode(), "1"));
            List auditInfoEntitys = respVo.getAuditInfoEntitys();
            String fineStr = "";
            String fineName = "";
            if (CollectionUtil.listNotEmptyNotSizeZero((List)auditInfoEntitys)) {
                fineStr = auditInfoEntitys.stream().map(TtAuditInfoEntity::getCode).collect(Collectors.joining(","));
                fineName = auditInfoEntitys.stream().map(TtAuditInfoEntity::getName).collect(Collectors.joining(","));
                detailVo.setFineStr(fineStr);
                detailVo.setFineName(fineName);
            }
        }
        List<Object> custTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getCustJson()) && (entities2 = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getCustJson(), FormTags[].class)) != null && entities2.length > 0) {
            custTags = Arrays.asList(entities2);
        }
        List<Object> orgTags = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)detailVo.getOrgJson()) && (entities = (FormTags[])JsonPropertyUtil.toObject((String)detailVo.getOrgJson(), FormTags[].class)) != null && ((Object)entities).length > 0) {
            orgTags = Arrays.asList(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(custTags)) {
            for (FormTags formTags : custTags) {
                TtActDetailEntity entity = (TtActDetailEntity)this.ttActDetailDao.selectByPrimaryKey(detailVo.getId());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setCustomerCode(formTags.getCode());
                entity.setCustomerName(formTags.getName());
                entity.setAuditStatus("0");
                this.validateGroup(entity, 1);
                entity.setId(null);
                entity.setActDetailCode(null);
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
            example = new Example(TtActDetailEntity.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("id", (Object)detailVo.getId());
            this.ttActDetailDao.deleteByExample(example);
        } else if (CollectionUtil.listNotEmptyNotSizeZero(orgTags)) {
            for (FormTags formTags : orgTags) {
                TtActDetailEntity entity = (TtActDetailEntity)this.ttActDetailDao.selectByPrimaryKey(detailVo.getId());
                MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
                entity.setOrgCode(formTags.getCode());
                entity.setOrgName(formTags.getName());
                entity.setAuditStatus("0");
                this.validateGroup(entity, 1);
                entity.setId(null);
                entity.setActDetailCode(null);
                actDetailEntities.add(entity);
            }
            i = this.insertList(actDetailEntities);
            example = new Example(TtActDetailEntity.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("id", (Object)detailVo.getId());
            this.ttActDetailDao.deleteByExample(example);
        } else {
            TtActDetailEntity entity = new TtActDetailEntity();
            entity.setEnableStatus(ConstantEnum.StatusEnum.UPDATE.getValue());
            MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
            this.validateGroup(entity, 1);
            actDetailEntities.add(entity);
            i = this.updateBatchByPrimaryKeySelective(actDetailEntities);
        }
        return i > 0;
    }

    private void validateGroup(TtActDetailEntity entity, int exclude) {
        if (StringUtil.isNotEmpty((CharSequence)entity.getGroupCode())) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("groupCode", (Object)entity.getGroupCode());
            if (exclude == 1) {
                criteria.andNotEqualTo("id", (Object)entity.getId());
            }
            List list = this.ttActDetailDao.selectByExample(example);
            BigDecimal[] use = new BigDecimal[]{BigDecimal.ZERO};
            list.stream().forEach(e -> {
                use[0] = use[0].add(e.getAmount());
            });
            if (entity.getGroupAmount().compareTo(use[0].add(entity.getAmount())) < 0) {
                throw new BusinessException("\u7533\u8bf7\u91d1\u989d\u8d85\u8fc7\u603b\u5206\u644a\u91d1\u989d[" + entity.getGroupAmount().toString() + "]");
            }
        }
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailByActsPage(TtActDetailVo vo, Page page, List<String> actCodes) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.findTtActDetailListByActs(vo, actCodes), (Page)page);
    }

    @Override
    public List<TtActDetailVo> findTtActDetailByQuery(TtActDetailVo vo) {
        return this.ttActDetailDao.findTtActDetailByQuery(vo);
    }

    @Override
    public List<TtActDetailVo> findActDetailByCon(String clientCode, String clientType) {
        List<TtActDetailVo> list = this.ttActDetailDao.findActDetailByCon(clientCode, clientType);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List ttCostTypeFines;
            List fineCodes = list.stream().map(TtActDetailVo::getActSubclassCode).distinct().collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(fineCodes) && CollectionUtil.listNotEmptyNotSizeZero((List)(ttCostTypeFines = this.ttCostTypeFeign.findFineListByCodes(fineCodes).getObjList()))) {
                HashMap fineMap = new HashMap();
                ttCostTypeFines.forEach(item -> {
                    if (!fineMap.containsKey(item.getFineCode())) {
                        fineMap.put(item.getFineCode(), item.getDiscernModel());
                    }
                });
                list.forEach(item -> {
                    if (fineMap.containsKey(item.getActSubclassCode())) {
                        item.setDiscernModel((String)fineMap.get(item.getActSubclassCode()));
                    }
                });
            }
            list.stream().filter(dd -> StringUtils.isNotBlank((String)dd.getDiscernModel())).forEach(item -> {
                Map map;
                KnlDictDataEntity data = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_project_group.getVal(), (String)item.getDiscernModel());
                if (data != null && (map = data.getExtendMap()) != null && map.size() > 0) {
                    String a = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_a.getVal()));
                    String b = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_b.getVal()));
                    String c = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_c.getVal()));
                    ArrayList<String> modelProjectNameList = new ArrayList<String>();
                    if (StringUtil.isNotEmpty((CharSequence)a)) {
                        KnlDictDataEntity aStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)a);
                        modelProjectNameList.add(aStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)b)) {
                        KnlDictDataEntity bStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)b);
                        modelProjectNameList.add(bStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)c)) {
                        KnlDictDataEntity cStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)c);
                        modelProjectNameList.add(cStr.getDictValue());
                    }
                    item.setModelProjectName(((Object)modelProjectNameList).toString().replace("[", "").replace("]", ""));
                }
            });
        }
        return list;
    }

    @Override
    public List<TtActDetailEntity> findDetailByCodes(List<String> codes) {
        List<Object> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(codes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public List<TtActDetailEntity> findDetailByActCodes(List<String> actCodes) {
        List<Object> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(actCodes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actCode", actCodes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public List<TtActDetailEntity> findEnableByActCodes(List<String> actCodes) {
        if (CollectionUtil.listEmpty(actCodes)) {
            return new ArrayList<TtActDetailEntity>();
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actCode", actCodes);
        criteria.andIn("enableStatus", (Iterable)Sets.newHashSet((Object[])new String[]{ConstantEnum.StatusEnum.NEW.getValue(), ConstantEnum.StatusEnum.UPDATE.getValue()}));
        List detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public TtActDetailEntity getEntity(String id, String actDetailCode) {
        if (StringUtil.isBlank((CharSequence)id) && StringUtil.isBlank((CharSequence)actDetailCode)) {
            return null;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TtActDetailEntity)this.ttActDetailDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotEmpty((CharSequence)actDetailCode)) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actDetailCode", (Object)actDetailCode);
            List detailEntities = this.ttActDetailDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)detailEntities)) {
                return (TtActDetailEntity)detailEntities.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public AjaxJson checkActDetail(String actDetailCode, BigDecimal auditAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TtActDetailEntity entity = this.getEntity(null, actDetailCode);
        TtCostTypeFineEntity costTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, entity.getActSubclassCode()).getObj();
        String isMultipleAudit = costTypeFineEntity.getIsMultipleAudit();
        if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)isMultipleAudit) && StringUtil.equals((String)entity.getAuditStatus(), (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
            throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + "\u53ea\u80fd\u6838\u9500\u4e00\u6b21");
        }
        ArrayList<String> rules = new ArrayList<String>();
        rules.add(ConstantEnum.FIELD_NAME.above_audit.name());
        Map map = this.ttCostTypeFeign.findCostTypeCons(actDetailCode, rules).getMapT();
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amount = entity.getAuditAmount() == null ? BigDecimal.ZERO : entity.getAuditAmount();
        amount = amount.add(auditAmount);
        if (map.isEmpty() || !map.containsKey(ConstantEnum.FIELD_NAME.above_audit.name())) {
            maxAmount = entity.getAmount();
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        } else {
            BigDecimal extraAuditRatio = costTypeFineEntity.getExtraAuditRatio();
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            maxAmount = entity.getAmount().multiply(extraAuditRatio).divide(new BigDecimal(100)).add(entity.getAmount());
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        }
        attributes.put("costTypeFineEntity", costTypeFineEntity);
        attributes.put("maxAmount", maxAmount);
        ajaxJson.setAttributes(attributes);
        return ajaxJson;
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailListPage(TtActDetailVo vo, Page page) {
        List<TtActDetailVo> list = this.ttActDetailDao.findTtActDetailListPage(vo);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> list, (Page)page);
        return pageInfo;
    }

    @Override
    public void deleteDetailByActCode(String actCode) {
        this.ttActDetailDao.deleteDetailByActCode(actCode);
    }

    @Override
    public void deleteDetailByDetaiCodes(List<String> actDetailCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(actDetailCodes)) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("actDetailCode", actDetailCodes);
            this.deleteByExample(example);
        }
    }

    @Override
    public List<TtActDetailVo> findTtActDetailListForEstimate(TtActDetailVo vo) {
        return this.ttActDetailDao.findTtActDetailListForEstimate(vo);
    }

    @Override
    public PageInfo<TtActDetailEntity> listPart(ActDetailListPartReq actDetailListPartReq) {
        Page page = new Page();
        page.setPage(actDetailListPartReq.getPageNum().toString());
        page.setRows(actDetailListPartReq.getPageSize().toString());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.listPart(actDetailListPartReq.getActDetailCode()), (Page)page);
        return pageInfo;
    }

    @Override
    public AjaxJson group(TtActDetailGroupVo ttActDetailGroupVO) {
        TtActDetailEntity entity = new TtActDetailEntity();
        entity.setId(ttActDetailGroupVO.getId());
        TtActDetailEntity result = (TtActDetailEntity)this.selectOne(entity);
        log.info("\u5f53\u524d\u9700\u8981\u5206\u7ec4\u6d3b\u52a8\u67e5\u8be2:{}", (Object)result);
        if (result == null || !StringUtils.isEmpty((String)result.getGroupCode())) {
            return AjaxJson.failure((boolean)false, (String)"\u5f53\u524d\u6570\u636e\u4e0d\u53ef\u62c6\u5206");
        }
        String beginTime = ttActDetailGroupVO.getBeginTime();
        String endTime = ttActDetailGroupVO.getEndTime();
        if (StringUtils.isEmpty((String)beginTime)) {
            return AjaxJson.failure((boolean)false, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)endTime)) {
            return AjaxJson.failure((boolean)false, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("yyyy-MM-dd".length() != beginTime.length()) {
            return AjaxJson.failure((boolean)false, (String)"\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5,\u9700\u8981\u4e3ayyyy-MM-dd!");
        }
        if ("yyyy-MM-dd".length() != endTime.length()) {
            return AjaxJson.failure((boolean)false, (String)"\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5,\u9700\u8981\u4e3ayyyy-MM-dd");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate start = null;
        LocalDate end = null;
        try {
            start = LocalDate.parse(beginTime, formatter);
            end = LocalDate.parse(endTime, formatter);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return AjaxJson.failure((boolean)false, (String)"\u5f00\u59cb\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5,\u9700\u8981\u4e3ayyyy-MM-dd");
        }
        int times = TtActDetailServiceImpl.monthDiff(start, end);
        if (times < 1) {
            return AjaxJson.failure((boolean)false, (String)"\u5f53\u524d\u6d3b\u52a8\u65f6\u95f4\u4e0d\u53ef\u62c6\u5206");
        }
        ArrayList<TtActDetailEntity> list = new ArrayList<TtActDetailEntity>();
        BigDecimal groupAmount = result.getGroupAmount();
        groupAmount = groupAmount == null ? BigDecimal.ZERO : groupAmount;
        BigDecimal average = groupAmount.divide(new BigDecimal(times + 1), 0, 1);
        for (int i = 0; i <= times; ++i) {
            TtActDetailEntity detailEntity = new TtActDetailEntity();
            BeanUtils.copyProperties((Object)result, (Object)detailEntity);
            LocalDate startTime = start.plusMonths(i);
            startTime = i == 0 ? startTime : startTime.with(TemporalAdjusters.firstDayOfMonth());
            detailEntity.setBeginDate(formatter.format(startTime));
            LocalDate lastDay = i == times ? end : startTime.with(TemporalAdjusters.lastDayOfMonth());
            detailEntity.setEndDate(formatter.format(lastDay));
            detailEntity.setId(null);
            detailEntity.setGroupCode(ttActDetailGroupVO.getId());
            detailEntity.setActDetailCode(null);
            if (StringUtil.isNotBlank((CharSequence)detailEntity.getBeginDate())) {
                detailEntity.setActYearMonth(detailEntity.getBeginDate().substring(0, 7));
            }
            detailEntity.setAmount(average);
            if (i == times) {
                detailEntity.setAmount(groupAmount.subtract(average.multiply(new BigDecimal(times))));
            }
            list.add(detailEntity);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.insertList(list);
            this.delete(entity);
            return AjaxJson.ok();
        }
        return AjaxJson.failure((boolean)false, (String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private LocalDateTime getLastDayOfMouth(LocalDateTime startTime) {
        LocalDate localDate = startTime.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate();
        return LocalDateTime.of(localDate, LocalTime.MAX);
    }

    private LocalDateTime getDayOfMouth(LocalDateTime startTime) {
        LocalDate localDate = startTime.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate();
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static int monthDiff(LocalDate dt1, LocalDate dt2) {
        int month1 = dt1.getMonthValue();
        int year1 = dt1.getYear();
        int month2 = dt2.getMonthValue();
        int year2 = dt2.getYear();
        return (year2 - year1) * 12 + (month2 - month1);
    }
}

