/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.TaProcessCheckServiceFeign;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessCheckController"})
public class TaProcessCheckController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessCheckController.class);
    @Autowired
    private TaProcessCheckServiceFeign taProcessCheckServiceFeign;

    @RequestMapping(value={"processcheckView"})
    public ModelAndView processcheckView(HttpServletRequest request, String processKey) {
        try {
            AjaxJson result = this.taProcessCheckServiceFeign.createProcessCheckJson(processKey);
            request.setAttribute("processCkRecord", result.getObj());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCheckView");
    }

    @RequestMapping(value={"checkQuerySet"})
    public ModelAndView checkQuerySet(HttpServletRequest request) {
        try {
            String title = request.getParameter("title");
            String processId = request.getParameter("processId");
            request.setAttribute("title", (Object)title);
            AjaxJson ajaxJson = this.taProcessCheckServiceFeign.checkQuerySetJson(processId);
            request.setAttribute("processCkParams", ajaxJson.getObj());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCkQuerySet");
    }

    @RequestMapping(value={"saveCkRecord"})
    @ResponseBody
    public AjaxJson saveCkRecord(HttpServletRequest request, String processId, String proCkQuerySet) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u4fdd\u5b58\u68c0\u6d4b\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        try {
            aj.setObj((Object)this.taProcessCheckServiceFeign.saveRecord(processId, proCkQuerySet));
            if (!aj.isSuccess()) {
                aj.setSuccess(false);
                aj.setMsg("\u4fdd\u5b58\u68c0\u6d4b\u8bb0\u5f55\u5931\u8d25");
            }
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u68c0\u6d4b\u8bb0\u5f55\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"updateCkRecord"})
    @ResponseBody
    public AjaxJson updateCkRecord(HttpServletRequest request, TaProcessCheckRecord entity) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u751f\u6210\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            aj = this.taProcessCheckServiceFeign.updateCkRecord(entity);
            if (!aj.isSuccess()) {
                aj.setSuccess(false);
                aj.setMsg("\u751f\u6210\u62a5\u544a\u5931\u8d25");
            }
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u751f\u6210\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"saveStopedNode"})
    @ResponseBody
    public AjaxJson saveStopedNode(HttpServletRequest request, String isStopCheck, String nodeCode, String recordId, String allCkState) {
        AjaxJson ajaxJson = this.taProcessCheckServiceFeign.saveStopedNode(isStopCheck, nodeCode, recordId, allCkState);
        return ajaxJson;
    }

    @RequestMapping(value={"passCkReq"})
    @ResponseBody
    public AjaxJson passCkReq(HttpServletRequest request, String nodeCode, String recordId) {
        AjaxJson ajaxJson = this.taProcessCheckServiceFeign.passCkReq(nodeCode, recordId);
        return ajaxJson;
    }

    @RequestMapping(value={"loadHisRecord"})
    @ResponseBody
    public List<TaProcessCkRecordVo> loadHisRecord(HttpServletRequest request, String processId) {
        AjaxJson ajaxJson = this.taProcessCheckServiceFeign.loadHisRecord(processId);
        return ajaxJson.getObjList();
    }

    @RequestMapping(value={"deleteHis"})
    @ResponseBody
    public AjaxJson deleteHis(HttpServletRequest request, String id) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u5220\u9664\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            aj = this.taProcessCheckServiceFeign.deleteHis(id);
            if (!aj.isSuccess()) {
                aj.setSuccess(false);
                aj.setMsg("\u5220\u9664\u62a5\u544a\u5931\u8d25");
            }
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u5220\u9664\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"openHis"})
    public ModelAndView openHis(HttpServletRequest request, String recordId) {
        String url = "com/biz/eisp/activiti/designer/processcheck/processCkHisDetail";
        try {
            AjaxJson ajaxJson = this.taProcessCheckServiceFeign.findRecordDetail(recordId);
            TaProcessCkRecordVo vo = (TaProcessCkRecordVo)ajaxJson.getObj();
            if (vo.getIsBatchUser() != null && vo.getIsBatchUser() == 1) {
                url = "com/biz/eisp/activiti/designer/processcheck/procCkBatchHisDetail";
            }
            request.setAttribute("processCkRecord", ajaxJson.getAttributes().get("voJson"));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new ModelAndView(url);
    }

    @RequestMapping(value={"toBatchCheck"})
    @ResponseBody
    public AjaxJson toBatchCheck(HttpServletRequest request, String processId, String proCkQuerySet) {
        AjaxJson aj = this.taProcessCheckServiceFeign.toBatchCheck(processId, proCkQuerySet);
        return aj;
    }

    @RequestMapping(value={"batchProgress"})
    @ResponseBody
    public AjaxJson batchProgress(HttpServletRequest request, String batchId) {
        AjaxJson aj = this.taProcessCheckServiceFeign.batchProgress(batchId);
        aj.setObj((Object)aj.getAttributes());
        return aj;
    }

    @RequestMapping(value={"saveBatchCk"})
    @ResponseBody
    public AjaxJson saveBatchCk(HttpServletRequest request, String batchId, String resultRemark) {
        AjaxJson aj = this.taProcessCheckServiceFeign.saveBatchCk(batchId, resultRemark);
        return aj;
    }
}

