/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.RuntimeFeign;
import com.biz.eisp.activiti.TaAttachmentFeign;
import com.biz.eisp.activiti.TaHandCopyAndCirculationFeign;
import com.biz.eisp.activiti.TaTaskFeign;
import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.enums.InOrOutType;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.util.ResourceService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taCarbonCopyController"})
public class TaCarbonCopyController {
    @Autowired
    private ResourceService resourceUtil;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TaHandCopyAndCirculationFeign taHandCopyAndCirculationFeign;
    @Autowired
    private TaTaskFeign taTaskFeign;
    @Autowired
    private TaAttachmentFeign taAttachmentFeign;
    @Autowired
    private RuntimeFeign runtimeFeign;

    @RequestMapping(value={"goAddCarbonCopyMain"})
    public ModelAndView goAddCarbonCopyMain(String id) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/carbonCopyMain");
        view.addObject("taProcessId", (Object)id);
        return view;
    }

    @RequestMapping(value={"goManualCarbonCopyMain"})
    public ModelAndView goManualCarbonCopyMain(String processInstanceId, String processDefinitionId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/manualCarbonCopyMain");
        view.addObject("taProcessId", null);
        view.addObject("processInstanceId", (Object)processInstanceId);
        view.addObject("processDefinitionId", (Object)processDefinitionId);
        return view;
    }

    @RequestMapping(value={"goCarbonCopyMain"})
    public ModelAndView goCarbonCopyMain() {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/taMyCarbonCopy");
        return view;
    }

    @RequestMapping(value={"goAddCirculationMain"})
    public ModelAndView goAddCirculationMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circulationMain");
        view.addObject("processInstanceId", (Object)processInstanceId);
        return view;
    }

    @RequestMapping(value={"goCopyAndCirculationTabs"})
    public ModelAndView goCopyAndCirculationTabs(TaCopyCirculationVo vo) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationTab");
        view.addObject("query", (Object)vo);
        return view;
    }

    @RequestMapping(value={"goCopyAndCirculationBusiness"})
    public ModelAndView goCopyAndCirculationBusiness(String businessKey, String processInstanceId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationBusinessForm");
        MyTaskVo processVo = (MyTaskVo)this.taTaskFeign.findProcessBasicInfoByProcinstId(processInstanceId).getObj();
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(processInstanceId).getObjList();
        view.addObject("processVo", (Object)processVo);
        view.addObject("attachment", (Object)attachments);
        return view;
    }

    @RequestMapping(value={"goCopyAndCirculationTaskForm"})
    public ModelAndView goCopyAndCirculationTaskForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = null;
        TaCopyCirculationVo queryVo = new TaCopyCirculationVo();
        List result = null;
        if (InOrOutType.IN.getValue().equals(vo.getInOutType())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateInForm");
            queryVo.setId(vo.getId());
            queryVo.setQueryCode(UserUtils.getUser().getPosCode());
            result = this.taHandCopyAndCirculationFeign.findCirculationMessage(queryVo).getObjList();
            String isReply = "0";
            for (TaCopyCirculationVo v : result) {
                if (!"1".equals(v.getIsReply())) continue;
                isReply = "1";
                break;
            }
            view.addObject("isReply", (Object)isReply);
        } else if (InOrOutType.OUT.getValue().equals(vo.getInOutType())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateOutForm");
            queryVo.setId(vo.getId());
            queryVo.setContentId(vo.getContentId());
            result = this.taHandCopyAndCirculationFeign.findCirculationMessage(queryVo).getObjList();
        }
        String piId = vo.getProcessInstanceId();
        AjaxJson ajaxJson = this.runtimeFeign.checkStatusByProcessInstanceId(piId);
        if (ajaxJson == null || !ajaxJson.isSuccess()) {
            throw new BusinessException("\u72b6\u6001\u83b7\u53d6\u5931\u8d25");
        }
        view.addObject("taskState", (Object)ajaxJson.getObj().toString());
        view.addObject("content", (Object)result);
        view.addObject("inOutType", (Object)vo.getInOutType());
        return view;
    }

    @RequestMapping(value={"goCopyOrCirculationOperateForm"})
    public ModelAndView goCopyOrCirculationOperateForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyOperateForm");
        request.setAttribute("processInstanceId", (Object)vo.getProcessInstanceId());
        this.setKeyIndicators(vo.getProcessInstanceId(), request);
        MyTaskVo taskVo = new MyTaskVo();
        taskVo.setIsCommunicate("C");
        taskVo.setProcessInstanceId(vo.getProcessInstanceId());
        MyTaskVo myTaskVo = new MyTaskVo();
        myTaskVo.setProcessInstanceId(vo.getProcessInstanceId());
        List logs = this.taTaskFeign.findApprovalLogs(myTaskVo).getObjList();
        logs = logs == null ? new ArrayList() : logs;
        request.setAttribute("log", (Object)logs);
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(vo.getProcessInstanceId()).getObjList();
        request.setAttribute("attachment", (Object)attachments);
        return view;
    }

    private void setKeyIndicators(String processInstanceId, HttpServletRequest request) {
        String modelAndView = ((String)this.taTaskFeign.getProcessInstanceBusinessForm(processInstanceId).getObj()).toString();
        if (modelAndView != null) {
            modelAndView = modelAndView + "&isKeyIndicators=true";
        }
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
    }

    @RequestMapping(value={"goCopyPersonInfoMain"})
    public ModelAndView goCopyPersonInfoMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyPersonInfoMain");
        return view;
    }

    @RequestMapping(value={"goCircularizePersonInfoMain"})
    public ModelAndView goCircularizePersonInfoMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circularizePersonInfoMain");
        return view;
    }
}

