/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.HistoryFeign;
import com.biz.eisp.activiti.TaAttachmentFeign;
import com.biz.eisp.activiti.TaCommunicateFeign;
import com.biz.eisp.activiti.TaProcessInstanceFeign;
import com.biz.eisp.activiti.TaProcessNodeAuthFeign;
import com.biz.eisp.activiti.TaTaskFeign;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalVo;
import com.biz.eisp.activiti.service.TaTaskDetailFormAttributesExtendService;
import com.biz.eisp.activiti.service.TaTaskDetailFormExtendService;
import com.biz.eisp.api.feign.RoleActivitiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.util.ResourceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taTaskController"})
public class TaTaskController {
    @Autowired
    private TaTaskFeign taTaskFeign;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaProcessInstanceFeign taProcessInstanceFeign;
    @Autowired
    private TaAttachmentFeign taAttachmentFeign;
    @Autowired
    private TaCommunicateFeign taCommunicateFeign;
    @Autowired
    private TaProcessNodeAuthFeign taProcessNodeAuthFeign;
    @Autowired
    private RoleActivitiFeign roleActivitiFeign;
    @Autowired
    private HistoryFeign historyFeign;
    @Autowired(required=false)
    private TaTaskDetailFormExtendService taTaskDetailFormExtendService;
    @Autowired(required=false)
    private TaTaskDetailFormAttributesExtendService taTaskDetailFormAttributesExtendService;

    @RequestMapping(value={"goMyTaskMain"})
    public ModelAndView goMyTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myTaskMain");
    }

    @RequestMapping(value={"goMyHistoryTaskMain"})
    public ModelAndView goMyHistoryTaskMain() {
        return new ModelAndView("com/biz/eisp/activiti/task/myHistoryTaskMain");
    }

    @RequestMapping(value={"goInstanceHandleTabForm"})
    public ModelAndView goInstanceHandleTabForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        String isCommunicate = myTaskVo.getIsCommunicate();
        String id = myTaskVo.getId();
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("isView", (Object)isView);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        request.setAttribute("isCommunicate", (Object)isCommunicate);
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/activiti/task/taskHandleTabForm");
    }

    @RequestMapping(value={"goTaskBusinessForm"})
    public ModelAndView goTaskBusinessForm(MyTaskVo myTaskVo, HttpServletRequest request, String isdetail) {
        String taskId = myTaskVo.getTaskId();
        BusinessFormVo formVo = (BusinessFormVo)this.taProcessInstanceFeign.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()).getObj();
        if (formVo != null) {
            String modelAndView = formVo.getModelandview() + "&id=" + formVo.getBusinessObjId();
            request.setAttribute("nodeStart", (Object)(modelAndView + "&isdetail=" + isdetail));
        }
        return new ModelAndView("com/biz/eisp/activiti/task/taskBusinessForm");
    }

    @RequestMapping(value={"goTaskOperateForm"})
    public ModelAndView goTaskOperateForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\u4e22\u5931");
        }
        List list = this.taTaskFeign.findActHiCommentEntity(processInstanceId).getObjList();
        if (!isView) {
            boolean hasRejectNodes = (Boolean)this.taTaskFeign.hasRejectNodes(taskId, processInstanceId).getObj();
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            request.setAttribute("isView", (Object)isView);
        }
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("voList", (Object)list);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskOperateForm");
    }

    @RequestMapping(value={"goReassignForm"})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    @RequestMapping(value={"goPositionList"})
    public ModelAndView goPositionList(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/positionList");
    }

    @RequestMapping(value={"goTaskAbstractForm"})
    public ModelAndView goTaskAbstractForm(String processInstanceId) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/task/taskAbstractForm");
        MyTaskVo processVo = (MyTaskVo)this.taTaskFeign.findProcessBasicInfoByProcinstId(processInstanceId).getObj();
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(processInstanceId).getObjList();
        mv.addObject("processVo", (Object)processVo);
        mv.addObject("attachment", (Object)attachments);
        return mv;
    }

    @RequestMapping(value={"goTaskDetailForm"})
    public ModelAndView goTaskDetailForm(MyTaskVo myTaskVo, HttpServletRequest request, Boolean booView) {
        String modelAndView;
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/task/taskDetailForm");
        BusinessFormVo businessFormVo = (BusinessFormVo)this.taProcessInstanceFeign.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()).getObj();
        mv.addObject("taskId", (Object)myTaskVo.getTaskId());
        mv.addObject("processInstanceId", (Object)myTaskVo.getProcessInstanceId());
        mv.addObject("businessKey", (Object)businessFormVo.getBusinessObjId());
        if (StringUtils.isNotBlank((CharSequence)businessFormVo.getBusinessObjId())) {
            myTaskVo.setBusinessObjId(businessFormVo.getBusinessObjId());
        }
        mv.addObject("currPositionCode", (Object)this.resource.getCurrPosition().getPositionCode());
        mv.addObject("isReadFlag", (Object)request.getParameter("isReadFlag"));
        mv.addObject("isCopy", (Object)request.getParameter("isCopy"));
        if (ConstantEnum.YesNoEnum.Y.getValue().equals(myTaskVo.getIsCommunicate())) {
            booView = true;
            TaCommunicateContentEntity communicateEntity = (TaCommunicateContentEntity)this.taCommunicateFeign.getCommunicateContentById(myTaskVo.getId()).getObj();
            mv.addObject("communicateContent", (Object)communicateEntity.getContent());
            mv.addObject("communicateId", (Object)communicateEntity.getId());
        }
        mv.addObject("booView", (Object)booView);
        mv.addObject("isCommunicate", (Object)myTaskVo.getIsCommunicate());
        if (!booView.booleanValue()) {
            boolean hasRejectNodes = (Boolean)this.taTaskFeign.hasRejectNodes(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId()).getObj();
            mv.addObject("hasRejectNodes", (Object)hasRejectNodes);
            List historicTaskInstanceVos = this.historyFeign.getHistoricTaskInstanceVo(myTaskVo.getProcessInstanceId()).getObjList();
            ArrayList backTaskIdlist = new ArrayList();
            HashMap mapTemp = new HashMap();
            historicTaskInstanceVos.forEach(item -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", item.getTaskDefinitionKey());
                map.put("name", item.getName());
                backTaskIdlist.add(map);
            });
            mv.addObject("processNode", backTaskIdlist);
        }
        if ((modelAndView = StringUtils.isBlank((CharSequence)myTaskVo.getTaskId()) ? businessFormVo.getModelandview() : ((BusinessFormVo)this.taTaskFeign.getTaskBusinessForm(myTaskVo.getTaskId()).getObj()).getModelandview()) != null) {
            modelAndView = modelAndView + "?isKeyIndicators=true&businessObjId=" + businessFormVo.getBusinessObjId();
        }
        mv.addObject("nodeStart", (Object)modelAndView);
        AjaxJson indicator = this.taTaskFeign.findKeyIndicators(myTaskVo);
        if (indicator.isSuccess()) {
            Map attrs = indicator.getAttributes();
            for (String attr : attrs.keySet()) {
                mv.addObject(attr, attrs.get(attr));
            }
        }
        List logs = this.taTaskFeign.findApprovalLogs(myTaskVo).getObjList();
        mv.addObject("log", (Object)logs);
        MyTaskVo processVo = (MyTaskVo)this.taTaskFeign.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId()).getObj();
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId()).getObjList();
        mv.addObject("processVo", (Object)processVo);
        mv.addObject("attachment", (Object)attachments);
        TaProcessNodeAuthVo nodeAuthVo = null;
        if (StringUtil.isNotEmpty((CharSequence)myTaskVo.getTaskId())) {
            nodeAuthVo = (TaProcessNodeAuthVo)this.taProcessNodeAuthFeign.getNodeAuthByTaskId(myTaskVo.getTaskId()).getObj();
        }
        mv.addObject("nodeAuth", nodeAuthVo);
        if (this.taTaskDetailFormAttributesExtendService != null) {
            this.taTaskDetailFormAttributesExtendService.setAttributes(mv, myTaskVo, booView, businessFormVo);
        }
        if (this.taTaskDetailFormExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.taTaskDetailFormExtendService.includeJsp());
        }
        return mv;
    }

    @RequestMapping(value={"goAgencyApproval"})
    public ModelAndView goAgencyApproval(HttpServletRequest request) {
        TaAgencyApprovalVo taAgencyApprovalVo = new TaAgencyApprovalVo();
        taAgencyApprovalVo.setRepresentedUserName(this.resource.getUserVo().getUsername());
        List list = this.taTaskFeign.findAgencyApprovalList(taAgencyApprovalVo).getObjList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            request.setAttribute("vo", list.get(0));
        }
        return new ModelAndView("com/biz/eisp/activiti/task/agencyApprovalMain");
    }

    @RequestMapping(value={"goAgencyApprovalProcess"})
    public ModelAndView goAgencyApprovalProcess(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/agencyApprovalProcessMain");
    }
}

