/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.controller;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taProcessBusinessObjConfigController"})
public class TaProcessBusinessObjConfigController {
    @Autowired
    private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
    @Autowired
    private TaBusinessObjService taBusinessObjService;

    @RequestMapping(value={"goConfigMain"})
    public ModelAndView goConfigMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(value={"goConfigForm"})
    public ModelAndView goConfigForm(String id, String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigForm");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessBusinessObjConfigVo vo = new TaProcessBusinessObjConfigEntityToVo().apply(this.taProcessBusinessObjConfigService.getConfigById(id));
            view.addObject("configVo", (Object)vo);
        }
        List<TaBusinessObjEntity> taBusinessObjVo = this.taBusinessObjService.findAllBusinessObj();
        view.addObject("taProcessId", (Object)taProcessId);
        view.addObject("taBusinessObjVos", taBusinessObjVo);
        return view;
    }

    @RequestMapping(value={"findConfigList"})
    @ResponseBody
    public DataGrid findConfigList(String taProcessId, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<TaProcessBusinessObjConfigVo> pageInfo = this.taProcessBusinessObjConfigService.findConfigByProcessId(taProcessId, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveOrUpdateConfig"})
    @ResponseBody
    public AjaxJson saveOrUpdateConfig(TaProcessBusinessObjConfigVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessBusinessObjConfigService.saveOrUpdateConfig(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setMsg("\u4fdd\u5b58\u6216\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    @RequestMapping(value={"delConfigById"})
    @ResponseBody
    public AjaxJson delConfigById(@RequestParam String id) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessBusinessObjConfigService.deleteConfig(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"validateBusinessName"})
    @ResponseBody
    public ValidForm validateBusinessName(String id, String param) {
        ValidForm validForm = new ValidForm();
        try {
            this.taProcessBusinessObjConfigService.validateBusinessName(id, param);
        }
        catch (BusinessException e) {
            validForm.setStatus("n");
            validForm.setInfo(e.getMessage());
        }
        return validForm;
    }
}

