/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taProcessNodeController"})
public class TaProcessNodeController {
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @RequestMapping(value={"goProcessNodePropertiesForm"})
    public ModelAndView goProcessNodePropertiesForm(HttpServletRequest request) {
        TaProcessVo taProcessVo;
        String turn = OConvertUtils.getString((String)request.getParameter("turn"));
        String id = OConvertUtils.getString((String)request.getParameter("id"));
        String checkbox = OConvertUtils.getString((String)request.getParameter("checkbox"));
        String processId = OConvertUtils.getString((String)request.getParameter("processId"));
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/designer/processconf/processnode/" + turn + "");
        String processDefinitionId = OConvertUtils.getString((String)request.getParameter("processDefinitionId"));
        if (StringUtil.isNotEmpty((CharSequence)processDefinitionId) && (taProcessVo = this.taProcessService.getProcessById(processDefinitionId)) != null) {
            mv.addObject("processDefinitionId", (Object)taProcessVo.getId());
            if (taProcessVo.getTypeId() != null) {
                mv.addObject("typeId", (Object)taProcessVo.getTypeId());
            }
            processId = taProcessVo.getProcessKey();
            mv.addObject("listenerClass", (Object)taProcessVo.getListenerClass());
            mv.addObject("tableName", (Object)taProcessVo.getTableName());
            mv.addObject("redirectUrl", (Object)taProcessVo.getRedirectUrl());
        }
        mv.addObject("checkbox", (Object)checkbox);
        mv.addObject("id", (Object)id);
        mv.addObject("processId", (Object)processId);
        mv.addObject("key", (Object)processId);
        return mv;
    }

    @RequestMapping(value={"goTaProcessTabs"})
    public ModelAndView goTaProcessTabs(String processId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessTabs");
        view.addObject("processId", (Object)processId);
        return view;
    }

    @RequestMapping(value={"goTaProcessNodeMain"})
    public ModelAndView goTaProcessNodeMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(value={"findNodeBypdKey"})
    @ResponseBody
    public DataGrid findNodeBypdKey(String taProcessId) {
        List<TaProcessNodeVo> list = this.taProcessNodeService.getNodeByProcessId(taProcessId);
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"goTaProcessNodeForm"})
    public ModelAndView goTaProcessNodeForm(String id, String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeForm");
        TaProcessNodeVo vo = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            vo = this.taProcessNodeService.getNodeById(id);
        } else {
            vo = new TaProcessNodeVo();
            vo.setTaProcessId(taProcessId);
        }
        view.addObject("nodeVo", (Object)vo);
        return view;
    }

    @RequestMapping(value={"saveOrUpdateTaProcessNode"})
    @ResponseBody
    public AjaxJson saveOrUpdateTaProcessNode(TaProcessNodeVo nodeVo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessNodeService.saveProcessNode(nodeVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"deleteTaProcessodeById"})
    @ResponseBody
    public AjaxJson deleteTaProcessNodeById(String id) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessNodeService.deleteProcessNodeById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"validateNode"})
    @ResponseBody
    public ValidForm validateNode(TaProcessNodeVo nodeVo, String param) {
        ValidForm vf = new ValidForm();
        try {
            if ("1".equals(nodeVo.getFlag())) {
                nodeVo.setProcessNodeCode(param);
            }
            if ("0".equals(nodeVo.getFlag())) {
                nodeVo.setProcessNodeName(param);
            }
            this.taProcessNodeService.validateNode(nodeVo);
        }
        catch (Exception e) {
            vf.setStatus("n");
            vf.setInfo(e.getMessage());
        }
        return vf;
    }
}

