/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeAuthDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessEntityToTaProcessVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessVoToTaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessService")
@Transactional
public class TaProcessServiceImpl
implements TaProcessService {
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaProcessNodeAuthDao taProcessNodeAuthDao;
    @Autowired
    private TaProcessNodeDao taProcessNodeDao;
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @Override
    public PageInfo<TaProcessEntity> findTaProcessList(Page page) {
        Example example = new Example(TaProcessEntity.class);
        Example.Criteria criteriarc = example.createCriteria();
        String processKey = (String)page.get((Object)"processKey");
        String processName = (String)page.get((Object)"processName");
        String processState = (String)page.get((Object)"processState");
        if (StringUtils.isNotBlank((CharSequence)processKey)) {
            criteriarc.andEqualTo("processKey", (Object)processKey);
        }
        if (StringUtils.isNotBlank((CharSequence)processName)) {
            criteriarc.andLike("processName", "%" + processName + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)processState)) {
            criteriarc.andEqualTo("processState", (Object)processState);
        }
        example.setOrderByClause("process_key asc");
        return PageAutoHelperUtil.generatePage(() -> this.taProcessDao.selectByExample(example), (Page)page);
    }

    @Override
    public TaProcessEntity saveTaProcess(TaProcessVo taProcessVo) {
        TaProcessEntity entity = new TaProcessVoToTaProcessEntity(this.taProcessNodeService, this.taProcessDao, this.taProcessNodeDao, this.taProcessNodeAuthDao).apply(taProcessVo);
        this.clearDirtyNodeInfo(taProcessVo, entity);
        return entity;
    }

    private void clearDirtyNodeInfo(TaProcessVo vo, TaProcessEntity entity) {
        String nodes = vo.getNodes();
        if (StringUtils.isNotBlank((CharSequence)nodes)) {
            String[] temp = nodes.split("@@@");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String aTemp : temp) {
                Object taProcessNodeEntity = null;
                String[] fileds = aTemp.split("###");
                String tid = fileds[0].substring(3);
                map.put(tid + "_" + vo.getProcessKey(), tid + "_" + vo.getProcessKey());
            }
            List<TaProcessNodeEntity> processNodeEntityList = entity.getTaProcessNodeEntityList();
            if (CollectionUtil.listNotEmptyNotSizeZero(processNodeEntityList)) {
                for (TaProcessNodeEntity processNodeEntity : processNodeEntityList) {
                    if (map.containsKey(processNodeEntity.getProcessNodeCode() + "_" + entity.getProcessKey())) continue;
                    this.taProcessNodeAuthDao.deleteByPrimaryKey(processNodeEntity.getId());
                    this.taProcessNodeDao.deleteByPrimaryKey(processNodeEntity.getId());
                }
            }
        }
    }

    @Override
    public void deleteTaProcess(String id) {
        this.taProcessDao.deleteByPrimaryKey(id);
    }

    @Override
    public TaProcessVo findProcessByKey(String key) {
        TaProcessEntity entity = new TaProcessEntity();
        entity.setProcessKey(key);
        TaProcessEntity tt = (TaProcessEntity)this.taProcessDao.selectOne(entity);
        if (StringUtil.isNotEmpty((CharSequence)tt.getTypeId())) {
            // empty if block
        }
        return new TaProcessEntityToTaProcessVo().apply(tt);
    }

    @Override
    public TaProcessVo getProcessById(String id) {
        TaProcessEntity entity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(id);
        return new TaProcessEntityToTaProcessVo().apply(entity);
    }
}

