/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.activiti.service.ActivitiRoleService;
import com.biz.eisp.activiti.util.ParamUtil;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.role.TmActRoleVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taCarbonCopyController"})
public class TaCarbonCopyController {
    @Autowired
    private ResourceService resourceUtil;
    @Autowired
    private ActivitiRoleService roleService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TaCarbonCopyService taCarbonCopyService;
    @Autowired
    private TaHandCopyAndCirculationService taHandCopyAndCirculationService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaAttachmentService taAttachmentService;
    @Autowired
    private RuntimeService runtimeService;

    @RequestMapping(value={"goAddCarbonCopyMain"})
    public ModelAndView goAddCarbonCopyMain(String id) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/carbonCopyMain");
        view.addObject("taProcessId", (Object)id);
        return view;
    }

    @RequestMapping(value={"getRolesOrPositions"})
    @ResponseBody
    public DataGrid getRolesOrPositions(String sendType, TmPositionVo vo, String roleName, String roleCode, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        if (sendType != null && "0".equals(sendType) || "".equals(sendType)) {
            PageInfo<TmActRoleVo> pageInfo = this.roleService.findRoleByCondition(roleCode, roleName, (Page)page);
            return new DataGrid(pageInfo);
        }
        if (sendType != null && sendType.equals("1")) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (!"-1".equals(vo.getOrgId()) && vo.getOrgId() != null) {
                map.put("orgId", vo.getOrgId());
            }
            map.put("page", page.getPage());
            map.put("rows", page.getRows());
            map.put("positionName", vo.getPositionName());
            map.put("positionCode", vo.getPositionCode());
            map.put("fullname", vo.getFullname());
            PageInfo pageInfo = this.tmPositionFeign.findPositionByPage(map).getPageInfo();
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList());
    }

    @RequestMapping(value={"saveCarbonCopy"})
    @ResponseBody
    public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.saveCarbonCopy(vo);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(value={"findCarbonCopyByTaProcessId"})
    @ResponseBody
    public DataGrid findCarbonCopyByTaProcessId(HttpServletRequest request, TaCarbonCopyVo taCarbonCopyVo) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = this.taCarbonCopyService.findTaCarbonCopy(taCarbonCopyVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"delCarbonCopyById"})
    @ResponseBody
    public AjaxJson delCarbonCopyById(String delIds) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.delCarbonCopyById(delIds);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(value={"findHomeCarbonCopyList"})
    @ResponseBody
    public DataGrid findHomeCarbonCopyList(TaCopyCirculationVo vo, String time, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        vo.setCreateDate(time);
        ParamUtil.packParams(vo, (Page)page);
        vo.setCreateDate(time);
        PageInfo pageInfo = this.taCarbonCopyService.findCopyAndCirculation(vo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goCarbonCopyMain"})
    public ModelAndView goCarbonCopyMain() {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/taMyCarbonCopy");
        return view;
    }

    @RequestMapping(value={"findCarbonCopyList"})
    @ResponseBody
    public DataGrid findCarbonCopyList(TaCopyCirculationVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ParamUtil.packParams(vo, (Page)page);
        PageInfo pageInfo = this.taCarbonCopyService.getCarbonCopyByConditions(vo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goAddCirculationMain"})
    public ModelAndView goAddCirculationMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circulationMain");
        view.addObject("processInstanceId", (Object)processInstanceId);
        return view;
    }

    @RequestMapping(value={"saveCirculation"})
    @ResponseBody
    public AjaxJson saveCirculation(String processInstanceId, String codes, String names, String fullNames, String content) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.saveCirculation(processInstanceId, codes, names, fullNames, content);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(value={"saveCirculationContent"})
    @ResponseBody
    public AjaxJson saveCirculationContent(String id, String content) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taHandCopyAndCirculationService.saveCirculationContent(id, content);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6570\u636e\u5e93\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(value={"goCopyAndCirculationTabs"})
    public ModelAndView goCopyAndCirculationTabs(TaCopyCirculationVo vo) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationTab");
        view.addObject("query", (Object)vo);
        return view;
    }

    @RequestMapping(value={"updateCarbonOrCirculationState"})
    @ResponseBody
    public AjaxJson updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taHandCopyAndCirculationService.updateCarbonOrCirculationState(vo);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"goCopyAndCirculationBusiness"})
    public ModelAndView goCopyAndCirculationBusiness(String businessKey, String processInstanceId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationBusinessForm");
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        List<TaAttachmentEntity> attachments = this.taAttachmentService.findAttachmentListByProcinstId(processInstanceId);
        view.addObject("processVo", (Object)processVo);
        view.addObject("attachment", attachments);
        return view;
    }

    @RequestMapping(value={"goCopyAndCirculationTaskForm"})
    public ModelAndView goCopyAndCirculationTaskForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = null;
        TaCopyCirculationVo queryVo = new TaCopyCirculationVo();
        List<TaCopyCirculationVo> result = null;
        if ("0".equals(vo.getInOutType())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateInForm");
            queryVo.setId(vo.getId());
            queryVo.setQueryCode(UserUtils.getUser().getPosCode());
            result = this.taHandCopyAndCirculationService.findCirculationMessage(queryVo);
            String isReply = "0";
            for (TaCopyCirculationVo v : result) {
                if (!"1".equals(v.getIsReply())) continue;
                isReply = "1";
                break;
            }
            view.addObject("isReply", (Object)isReply);
        } else if ("1".equals(vo.getInOutType())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateOutForm");
            queryVo.setId(vo.getId());
            queryVo.setContentId(vo.getContentId());
            result = this.taHandCopyAndCirculationService.findCirculationMessage(queryVo);
        }
        String piId = vo.getProcessInstanceId();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
        if (processInstance == null) {
            view.addObject("taskState", (Object)0);
        } else {
            view.addObject("taskState", (Object)1);
        }
        view.addObject("content", result);
        view.addObject("inOutType", (Object)vo.getInOutType());
        return view;
    }

    @RequestMapping(value={"goCopyOrCirculationOperateForm"})
    public ModelAndView goCopyOrCirculationOperateForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyOperateForm");
        request.setAttribute("processInstanceId", (Object)vo.getProcessInstanceId());
        this.setKeyIndicators(vo.getProcessInstanceId(), request);
        MyTaskVo taskVo = new MyTaskVo();
        taskVo.setIsCommunicate("C");
        taskVo.setProcessInstanceId(vo.getProcessInstanceId());
        this.taTaskService.findApprovalLogs(taskVo);
        return view;
    }

    private void setKeyIndicators(String processInstanceId, HttpServletRequest request) {
        String modelAndView = this.taTaskService.getProcessInstanceBusinessForm(processInstanceId);
        if (modelAndView != null) {
            modelAndView = modelAndView + "&isKeyIndicators=true";
        }
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
    }

    @RequestMapping(value={"goCopyPersonInfoMain"})
    public ModelAndView goCopyPersonInfoMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyPersonInfoMain");
        return view;
    }

    @RequestMapping(value={"goCircularizePersonInfoMain"})
    public ModelAndView goCircularizePersonInfoMain(String processInstanceId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circularizePersonInfoMain");
        return view;
    }

    @RequestMapping(value={"findCopyPersonInfoList"})
    @ResponseBody
    public DataGrid findCopyPersonInfoList(TaCopyPersonInfoVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo result = this.taCarbonCopyService.findCopyPersonInfoList(vo, (Page)page).getPageInfo();
        return new DataGrid(result);
    }

    @RequestMapping(value={"findCircularizePersonInfoList"})
    @ResponseBody
    public DataGrid findCircularizePersonInfoList(TaCopyCirculationVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo result = this.taCarbonCopyService.findCircularizePersonInfoList(vo, (Page)page).getPageInfo();
        return new DataGrid(result);
    }
}

