/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjQueryDao;
import com.biz.eisp.activiti.runtime.dao.TaRuntimeStatusDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taBaseBusinessObjService")
@Transactional
public class TaBaseBusinessObjServiceImpl
implements TaBaseBusinessObjService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaRuntimeStatusDao taRuntimeStatusDao;
    @Autowired
    private TaBaseBusinessObjQueryDao taBaseBusinessObjQueryDao;

    @Override
    public void updateBaseBusinessObjRuntimeStatus(String businessObjId, String runtimeStatusCode) {
        TaBaseBusinessObjQueryEntity entity = (TaBaseBusinessObjQueryEntity)this.taBaseBusinessObjQueryDao.selectByPrimaryKey(businessObjId);
        TaRuntimeStatusEntity statusEntity = new TaRuntimeStatusEntity();
        statusEntity.setCode(runtimeStatusCode);
        statusEntity = (TaRuntimeStatusEntity)this.taRuntimeStatusDao.selectOne(statusEntity);
        if (statusEntity != null) {
            entity.setRuntimeStatusId(statusEntity.getId());
            this.taBaseBusinessObjQueryDao.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public void updateBaseBusinessObjRuntimeStatusByProcessInstanceId(String processInstanceId, String runtimeStatusCode) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String businessObjId = historicProcessInstance.getBusinessKey();
        this.updateBaseBusinessObjRuntimeStatus(businessObjId, runtimeStatusCode);
    }
}

