/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjDao;
import com.biz.eisp.activiti.runtime.dao.TaRejectRecordDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.transformer.TaRejectRecordVoToTaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taRejectRecordService")
@Transactional
public class TaRejectRecordServiceImpl
implements TaRejectRecordService {
    @Autowired
    private TaRejectRecordDao taRejectRecordDao;
    @Autowired
    private TaBaseBusinessObjDao taBaseBusinessObjDao;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TmUserFeign tmUserFeign;

    @Override
    public void saveTaRejectRecord(String processInstanceId) {
        List<TaRejectRecordVo> taRejectRecordVoList = this.taRejectRecordDao.getTaRejectRecordVo(processInstanceId);
        TaRejectRecordVo taRejectRecordVo = taRejectRecordVoList.get(0);
        taRejectRecordVo.setRejectPositionCode(this.resource.getCurrPosition().getPositionCode());
        taRejectRecordVo.setRejectPositionName(this.resource.getCurrPosition().getPositionName());
        taRejectRecordVo.setRejectUserName(this.resource.getUserVo().getFullname());
        taRejectRecordVo.setReadStatus(0);
        TaRejectRecordEntity entity = new TaRejectRecordVoToTaRejectRecordEntity(this.taRejectRecordDao).apply(taRejectRecordVo);
        this.taRejectRecordDao.insertSelective(entity);
    }

    @Override
    public void saveTaRejectRecord(String processInstanceId, String positionId) {
        TmUserVo userVo = (TmUserVo)this.tmUserFeign.findPositionUser(positionId).getObj();
        List<TaRejectRecordVo> taRejectRecordVoList = this.taRejectRecordDao.getTaRejectRecordVo(processInstanceId);
        TaRejectRecordVo taRejectRecordVo = taRejectRecordVoList.get(0);
        taRejectRecordVo.setRejectPositionCode(userVo.getPosCode());
        taRejectRecordVo.setRejectPositionName(userVo.getPosName());
        taRejectRecordVo.setRejectUserName(userVo.getUsername());
        taRejectRecordVo.setReadStatus(0);
        TaRejectRecordEntity entity = new TaRejectRecordVoToTaRejectRecordEntity(this.taRejectRecordDao).apply(taRejectRecordVo);
        this.taRejectRecordDao.insertSelective(entity);
    }

    @Override
    public AjaxJson<TaRejectRecordEntity> findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, Page page) {
        PageInfo infoList;
        if (!CollectionUtil.listNotEmptyNotSizeZero(taRejectRecordVo.getAssigneeList())) {
            TaRejectRecordEntity record = new TaRejectRecordEntity();
            record.setId("-1");
            if (StringUtil.isNotEmpty((CharSequence)taRejectRecordVo.getViewStatus())) {
                record.setViewStatus(Integer.valueOf(taRejectRecordVo.getViewStatus()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)(infoList = PageAutoHelperUtil.generatePage(() -> this.taRejectRecordDao.select(record), (Page)page)).getList())) {
                List list = infoList.getList();
                for (TaRejectRecordEntity entity : list) {
                    TaBaseBusinessObjEntity taBaseBusinessObj = (TaBaseBusinessObjEntity)this.taBaseBusinessObjDao.selectByPrimaryKey(entity.getBusinessObjId());
                    if (null == taBaseBusinessObj) continue;
                    entity.setBusinessObjNum(taBaseBusinessObj.getNum());
                }
                infoList.setList(list);
            }
        } else {
            infoList = PageAutoHelperUtil.generatePage(() -> this.taRejectRecordDao.findMyRejectTaskList(taRejectRecordVo), (Page)page);
        }
        AjaxJson result = new AjaxJson();
        result.setPageInfo(infoList);
        return result;
    }

    @Override
    public void updateTaRejectRecordStatus(String id) {
        TaRejectRecordEntity entity = (TaRejectRecordEntity)this.taRejectRecordDao.selectByPrimaryKey(id);
        entity.setReadStatus(1);
        this.taRejectRecordDao.updateByPrimaryKeySelective(entity);
    }
}

